/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.RpcContext;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.RpcContextKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RpcContextBuilder
implements Builder<RpcContext> {
    private String _identifier;
    private RpcContextKey key;
    Map<Class<? extends Augmentation<RpcContext>>, Augmentation<RpcContext>> augmentation = Collections.emptyMap();

    public RpcContextBuilder() {
    }

    public RpcContextBuilder(RpcContext base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RpcContext>>, Augmentation<RpcContext>>(aug);
        }
        this.key = base.key();
        this._identifier = base.getIdentifier();
    }

    public RpcContextKey key() {
        return this.key;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public <E$$ extends Augmentation<RpcContext>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RpcContextBuilder withKey(RpcContextKey key) {
        this.key = key;
        return this;
    }

    public RpcContextBuilder setIdentifier(String value) {
        this._identifier = value;
        return this;
    }

    public RpcContextBuilder addAugmentation(Augmentation<RpcContext> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public RpcContextBuilder addAugmentation(Class<? extends Augmentation<RpcContext>> augmentationType, Augmentation<RpcContext> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public RpcContextBuilder removeAugmentation(Class<? extends Augmentation<RpcContext>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private RpcContextBuilder doAddAugmentation(Class<? extends Augmentation<RpcContext>> augmentationType, Augmentation<RpcContext> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RpcContext>>, Augmentation<RpcContext>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RpcContext build() {
        return new RpcContextImpl(this);
    }

    private static final class RpcContextImpl
    extends AbstractAugmentable<RpcContext>
    implements RpcContext {
        private final String _identifier;
        private final RpcContextKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RpcContextImpl(RpcContextBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new RpcContextKey(base.getIdentifier());
            this._identifier = this.key.getIdentifier();
        }

        @Override
        public RpcContextKey key() {
            return this.key;
        }

        @Override
        public String getIdentifier() {
            return this._identifier;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._identifier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RpcContext.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            RpcContext other = (RpcContext)obj;
            if (!Objects.equals(this._identifier, other.getIdentifier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RpcContextImpl otherImpl = (RpcContextImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"RpcContext");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_identifier", (Object)this._identifier);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

