/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.generator.api.BindingGenerator;
import org.opendaylight.mdsal.binding.generator.impl.CodegenTypeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.GeneratorUtils;
import org.opendaylight.mdsal.binding.generator.impl.RenameMappingException;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

@Singleton
@Beta
public final class DefaultBindingGenerator
implements BindingGenerator {
    public List<Type> generateTypes(EffectiveModelContext context, Collection<? extends Module> modules) {
        return DefaultBindingGenerator.generateFor(context, modules);
    }

    @VisibleForTesting
    static @NonNull List<Type> generateFor(EffectiveModelContext context) {
        return DefaultBindingGenerator.generateFor(context, context.getModules());
    }

    @VisibleForTesting
    static @NonNull List<Type> generateFor(EffectiveModelContext context, Collection<? extends Module> modules) {
        GeneratorUtils.checkContext((SchemaContext)context);
        Preconditions.checkArgument((modules != null ? 1 : 0) != 0, (Object)"Set of Modules cannot be NULL.");
        IdentityHashMap<SchemaNode, JavaTypeName> renames = new IdentityHashMap<SchemaNode, JavaTypeName>();
        while (true) {
            try {
                return new CodegenTypeGenerator(context, renames).toTypes(modules);
            }
            catch (RenameMappingException e) {
                GeneratorUtils.rename(renames, e);
                continue;
            }
            break;
        }
    }
}

