/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccessProxyV1;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;

@Beta
public final class ConnectClientSuccess
extends RequestSuccess<ClientIdentifier, ConnectClientSuccess> {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but this class implements writeReplace to delegate serialization to a Proxy class and thus instances of this class aren't serialized. FindBugs does not recognize this.")
    private final @NonNull List<ActorSelection> alternates;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="See justification above.")
    private final ReadOnlyDataTree dataTree;
    private final @NonNull ActorRef backend;
    private final int maxMessages;

    ConnectClientSuccess(ClientIdentifier target, long sequence, ActorRef backend, List<ActorSelection> alternates, int maxMessages, ReadOnlyDataTree dataTree) {
        super(target, sequence);
        this.backend = Objects.requireNonNull(backend);
        this.alternates = ImmutableList.copyOf(alternates);
        this.dataTree = dataTree;
        Preconditions.checkArgument((maxMessages > 0 ? 1 : 0) != 0, (String)"Maximum messages has to be positive, not %s", (int)maxMessages);
        this.maxMessages = maxMessages;
    }

    public ConnectClientSuccess(@NonNull ClientIdentifier target, long sequence, @NonNull ActorRef backend, @NonNull List<ActorSelection> alternates, @NonNull ReadOnlyDataTree dataTree, int maxMessages) {
        this(target, sequence, backend, alternates, maxMessages, Objects.requireNonNull(dataTree));
    }

    public @NonNull List<ActorSelection> getAlternates() {
        return this.alternates;
    }

    public @NonNull ActorRef getBackend() {
        return this.backend;
    }

    public Optional<ReadOnlyDataTree> getDataTree() {
        return Optional.ofNullable(this.dataTree);
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    @Override
    protected ConnectClientSuccessProxyV1 externalizableProxy(ABIVersion version) {
        return new ConnectClientSuccessProxyV1(this);
    }

    @Override
    protected ConnectClientSuccess cloneAsVersion(ABIVersion version) {
        return this;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("alternates", this.alternates).add("dataTree present", this.getDataTree().isPresent()).add("maxMessages", this.maxMessages);
    }
}

