/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import com.google.common.annotations.Beta;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.AbstractMessageProxy;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class AbstractRequestProxy<T extends WritableIdentifier, C extends Request<T, C>>
extends AbstractMessageProxy<T, C> {
    private static final long serialVersionUID = 1L;
    private ActorRef replyTo;

    protected AbstractRequestProxy() {
    }

    protected AbstractRequestProxy(@NonNull C request) {
        super(request);
        this.replyTo = ((Request)request).getReplyTo();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(Serialization.serializedActorPath((ActorRef)this.replyTo));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.replyTo = ((ExtendedActorSystem)JavaSerializer.currentSystem().value()).provider().resolveActorRef((String)in.readObject());
    }

    @Override
    final C createMessage(T target, long sequence) {
        return this.createRequest(target, sequence, this.replyTo);
    }

    protected abstract @NonNull C createRequest(@NonNull T var1, long var2, @NonNull ActorRef var4);
}

