/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.Equivalence;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.MutableEntrySet;
import tech.pantheon.triemap.MutableIterator;
import tech.pantheon.triemap.MutableKeySet;
import tech.pantheon.triemap.PresencePredicate;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

public final class MutableTrieMap<K, V>
extends TrieMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceFieldUpdater<MutableTrieMap, Object> ROOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MutableTrieMap.class, Object.class, "root");
    private volatile Object root;

    MutableTrieMap(Equivalence<? super K> equiv) {
        this(equiv, MutableTrieMap.newRootNode());
    }

    MutableTrieMap(Equivalence<? super K> equiv, INode<K, V> root) {
        super(equiv);
        this.root = Objects.requireNonNull(root);
    }

    @Override
    public void clear() {
        INode localRoot;
        while (!this.rdcssRoot(localRoot = this.readRoot(), localRoot.gcasRead(this), MutableTrieMap.newRootNode())) {
        }
    }

    @Override
    public V put(K key, V value) {
        K k = Objects.requireNonNull(key);
        return MutableTrieMap.toNullable(this.insertifhc(k, this.computeHash(k), Objects.requireNonNull(value), null));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        K k = Objects.requireNonNull(key);
        return MutableTrieMap.toNullable(this.insertifhc(k, this.computeHash(k), Objects.requireNonNull(value), (Object)PresencePredicate.ABSENT));
    }

    @Override
    public V remove(Object key) {
        Object k = Objects.requireNonNull(key);
        return MutableTrieMap.toNullable(this.removehc(k, null, this.computeHash(k)));
    }

    @Override
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="API contract allows null value, but we do not")
    public boolean remove(Object key, Object value) {
        Object k = Objects.requireNonNull(key);
        return this.removehc(k, Objects.requireNonNull(value), this.computeHash(k)).isPresent();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        K k = Objects.requireNonNull(key);
        return this.insertifhc(k, this.computeHash(k), Objects.requireNonNull(newValue), Objects.requireNonNull(oldValue)).isPresent();
    }

    @Override
    public V replace(K key, V value) {
        K k = Objects.requireNonNull(key);
        return MutableTrieMap.toNullable(this.insertifhc(k, this.computeHash(k), Objects.requireNonNull(value), (Object)PresencePredicate.PRESENT));
    }

    @Override
    public int size() {
        return this.immutableSnapshot().size();
    }

    private INode<K, V> snapshot() {
        INode localRoot;
        while (!this.rdcssRoot(localRoot = this.readRoot(), localRoot.gcasRead(this), localRoot.copyToGen(new Gen(), this))) {
        }
        return localRoot;
    }

    @Override
    public ImmutableTrieMap<K, V> immutableSnapshot() {
        return new ImmutableTrieMap<K, V>(this.snapshot(), this.equiv());
    }

    @Override
    public MutableTrieMap<K, V> mutableSnapshot() {
        return new MutableTrieMap(this.equiv(), this.snapshot().copyToGen(new Gen(), this));
    }

    @Override
    MutableEntrySet<K, V> createEntrySet() {
        return new MutableEntrySet(this);
    }

    @Override
    MutableKeySet<K> createKeySet() {
        return new MutableKeySet(this);
    }

    @Override
    MutableIterator<K, V> iterator() {
        return new MutableIterator(this);
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    INode<K, V> rdcssReadRoot(boolean abort) {
        Object r = this.root;
        if (r instanceof INode) {
            return (INode)r;
        }
        MutableTrieMap.verifyRootDescriptor(r);
        return this.rdcssComplete(abort);
    }

    void add(K key, V value) {
        K k = Objects.requireNonNull(key);
        this.inserthc(k, this.computeHash(k), Objects.requireNonNull(value));
    }

    private static <K, V> INode<K, V> newRootNode() {
        Gen gen = new Gen();
        return new INode(gen, new CNode(gen));
    }

    private void inserthc(K key, int hc, V value) {
        if (!this.readRoot().recInsert(key, value, hc, 0, null, this)) {
            throw new VerifyException("Concurrent modification during serialization of map " + this);
        }
    }

    private Optional<V> insertifhc(K key, int hc, V value, Object cond) {
        Optional res;
        while ((res = this.readRoot().recInsertIf(key, value, hc, cond, 0, null, this)) == null) {
        }
        return res;
    }

    private Optional<V> removehc(K key, Object cond, int hc) {
        Optional res;
        while ((res = this.readRoot().recRemove(key, cond, hc, 0, null, this)) == null) {
        }
        return res;
    }

    private boolean casRoot(Object ov, Object nv) {
        return ROOT_UPDATER.compareAndSet(this, ov, nv);
    }

    private boolean rdcssRoot(INode<K, V> ov, MainNode<K, V> expectedmain, INode<K, V> nv) {
        RDCSS_Descriptor<K, V> desc = new RDCSS_Descriptor<K, V>(ov, expectedmain, nv);
        if (this.casRoot(ov, desc)) {
            this.rdcssComplete(false);
            return desc.committed;
        }
        return false;
    }

    private INode<K, V> rdcssComplete(boolean abort) {
        INode ov;
        while (true) {
            Object r;
            if ((r = this.root) instanceof INode) {
                return (INode)r;
            }
            MutableTrieMap.verifyRootDescriptor(r);
            RDCSS_Descriptor desc = (RDCSS_Descriptor)r;
            ov = desc.old;
            MainNode exp = desc.expectedmain;
            INode nv = desc.nv;
            if (abort) {
                if (!this.casRoot(desc, ov)) continue;
                return ov;
            }
            MainNode oldmain = ov.gcasRead(this);
            if (oldmain == exp) {
                if (!this.casRoot(desc, nv)) continue;
                desc.committed = true;
                return nv;
            }
            if (this.casRoot(desc, ov)) break;
        }
        return ov;
    }

    private static void verifyRootDescriptor(Object obj) {
        if (!(obj instanceof RDCSS_Descriptor)) {
            throw new VerifyException("Unhandled root " + obj);
        }
    }

    private static final class RDCSS_Descriptor<K, V> {
        final INode<K, V> old;
        final MainNode<K, V> expectedmain;
        final INode<K, V> nv;
        volatile boolean committed = false;

        RDCSS_Descriptor(INode<K, V> old, MainNode<K, V> expectedmain, INode<K, V> nv) {
            this.old = old;
            this.expectedmain = expectedmain;
            this.nv = nv;
        }
    }
}

