/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import tech.pantheon.triemap.AbstractKeySet;
import tech.pantheon.triemap.ImmutableTrieSet;
import tech.pantheon.triemap.MutableTrieSet;
import tech.pantheon.triemap.TrieMap;

public abstract class TrieSet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 0L;
    private final TrieMap<E, Boolean> map;
    private final AbstractKeySet<E> set;

    TrieSet(TrieMap<E, Boolean> map) {
        this.map = Objects.requireNonNull(map);
        this.set = map.createKeySet();
    }

    public static <E> MutableTrieSet<E> create() {
        return new MutableTrieSet(TrieMap.create());
    }

    public final MutableTrieSet<E> mutableSnapshot() {
        return new MutableTrieSet<E>(this.map.mutableSnapshot());
    }

    public abstract ImmutableTrieSet<E> immutableSnapshot();

    @Override
    public final boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public final boolean add(E e) {
        return this.map.putIfAbsent(e, Boolean.TRUE) == null;
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        boolean ret = false;
        for (E e : c) {
            ret |= this.add(e);
        }
        return ret;
    }

    @Override
    public final boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final void clear() {
        this.map.clear();
    }

    @Override
    public final Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public final void forEach(Consumer<? super E> action) {
        this.set.forEach(action);
    }

    @Override
    public final boolean removeIf(Predicate<? super E> filter) {
        return this.set.removeIf(filter);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public final Spliterator<E> spliterator() {
        return this.set.spliterator();
    }

    @Override
    public final Stream<E> stream() {
        return this.set.stream();
    }

    @Override
    public final Stream<E> parallelStream() {
        return this.set.parallelStream();
    }

    @Override
    public final int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return obj == this || this.set.equals(obj);
    }

    public final String toString() {
        return this.set.toString();
    }

    final Object writeReplace() {
        return new SerializedForm(this);
    }

    final TrieMap<E, Boolean> map() {
        return this.map;
    }

    private static final class SerializedForm
    implements Externalizable {
        private static final long serialVersionUID = 0L;
        private TrieSet<?> set;

        public SerializedForm() {
        }

        SerializedForm(TrieSet<?> set) {
            this.set = Objects.requireNonNull(set);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            ImmutableTrieSet<?> snap = this.set.immutableSnapshot();
            out.writeBoolean(this.set instanceof ImmutableTrieSet);
            out.writeInt(snap.size());
            for (Object e : snap) {
                out.writeObject(e);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean readOnly = in.readBoolean();
            int size = in.readInt();
            if (size < 0) {
                throw new StreamCorruptedException("Expected non-negative size instead of " + size);
            }
            MutableTrieSet<Object> read = TrieSet.create();
            for (int i = 0; i < size; ++i) {
                read.add(in.readObject());
            }
            this.set = readOnly ? read.immutableSnapshot() : read;
        }

        Object readResolve() {
            return this.set;
        }
    }
}

