/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.undertow.internal;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.PeerNameResolvingHandler;
import io.undertow.server.handlers.ProxyPeerAddressHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.util.InMemorySessionPersistence;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.SAXParserFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.ConfigurationSource;
import org.ops4j.pax.web.service.spi.LifeCycle;
import org.ops4j.pax.web.service.spi.ServerController;
import org.ops4j.pax.web.service.spi.ServerControllerEx;
import org.ops4j.pax.web.service.spi.ServerEvent;
import org.ops4j.pax.web.service.spi.ServerListener;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.ResourceModel;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.ops4j.pax.web.service.spi.model.WelcomeFileModel;
import org.ops4j.pax.web.service.undertow.internal.CertificateValidator;
import org.ops4j.pax.web.service.undertow.internal.Context;
import org.ops4j.pax.web.service.undertow.internal.ContextAwarePathHandler;
import org.ops4j.pax.web.service.undertow.internal.FileSessionPersistence;
import org.ops4j.pax.web.service.undertow.internal.ResourceServlet;
import org.ops4j.pax.web.service.undertow.internal.UndertowUtil;
import org.ops4j.pax.web.service.undertow.internal.configuration.ResolvingContentHandler;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.SecurityRealm;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.Server;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.ServletContainer;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.UndertowConfiguration;
import org.ops4j.pax.web.service.undertow.internal.configuration.model.UndertowSubsystem;
import org.ops4j.pax.web.service.undertow.internal.security.JaasIdentityManager;
import org.ops4j.pax.web.service.undertow.internal.security.PropertiesIdentityManager;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.XnioWorker;

public class ServerControllerImpl
implements ServerController,
ServerControllerEx,
IdentityManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServerControllerImpl.class);
    private final BundleContext bundleContext;
    private JAXBContext jaxb = null;
    private Configuration configuration;
    private final Set<ServerListener> listeners = new CopyOnWriteArraySet<ServerListener>();
    private State state = State.Unconfigured;
    private IdentityManager identityManager;
    private SessionPersistenceManager sessionPersistenceManager;
    private int defaultSessionTimeoutInMinutes;
    private final ContextAwarePathHandler path = new ContextAwarePathHandler((HttpHandler)Handlers.path());
    private Undertow server;
    private final ConcurrentMap<HttpContext, Context> contextMap = new ConcurrentHashMap<HttpContext, Context>();
    private XnioWorker xnioWorker;

    public ServerControllerImpl(BundleContext context) {
        this.bundleContext = context;
    }

    public synchronized void start() {
        LOG.debug("Starting server [{}]", (Object)this);
        this.assertState(State.Stopped);
        this.doStart();
        this.state = State.Started;
        this.notifyListeners(ServerEvent.STARTED);
    }

    public synchronized void stop() {
        LOG.debug("Stopping server [{}]", (Object)this);
        this.assertNotState(State.Unconfigured);
        if (this.state == State.Started) {
            this.doStop();
            this.state = State.Stopped;
        }
        this.notifyListeners(ServerEvent.STOPPED);
    }

    public synchronized void configure(Configuration config) {
        LOG.debug("Configuring server [{}] -> [{}] ", (Object)this, (Object)config);
        if (config == null) {
            throw new IllegalArgumentException("configuration == null");
        }
        this.configuration = config;
        switch (this.state) {
            case Unconfigured: {
                this.doConfigure();
                this.state = State.Stopped;
                this.notifyListeners(ServerEvent.CONFIGURED);
                break;
            }
            case Started: {
                this.doConfigure();
                this.state = State.Stopped;
                this.notifyListeners(ServerEvent.CONFIGURED);
                this.doStop();
                this.state = State.Stopped;
                this.notifyListeners(ServerEvent.STOPPED);
                this.doStart();
                this.state = State.Started;
                this.notifyListeners(ServerEvent.STARTED);
            }
        }
    }

    public void addListener(ServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        this.listeners.add(listener);
    }

    public void removeListener(ServerListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized boolean isStarted() {
        return this.state == State.Started;
    }

    public synchronized boolean isConfigured() {
        return this.state != State.Unconfigured;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public synchronized Integer getHttpPort() {
        Configuration config = this.configuration;
        if (config == null) {
            throw new IllegalStateException("Not configured");
        }
        return config.getHttpPort();
    }

    public synchronized Integer getHttpSecurePort() {
        Configuration config = this.configuration;
        if (config == null) {
            throw new IllegalStateException("Not configured");
        }
        return config.getHttpSecurePort();
    }

    void notifyListeners(ServerEvent event) {
        for (ServerListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void doConfigure() {
        Undertow.Builder builder = Undertow.builder();
        ContextAwarePathHandler rootHandler = this.path;
        URL undertowResource = this.detectUndertowConfiguration();
        ConfigSource source = ConfigSource.kind(undertowResource);
        switch (source) {
            case XML: {
                LOG.info("Using \"" + undertowResource + "\" to configure Undertow");
                rootHandler = this.configureUndertow(this.configuration, builder, (HttpHandler)rootHandler, undertowResource);
                break;
            }
            case PROPERTIES: {
                LOG.info("Using \"" + undertowResource + "\" to read additional configuration for Undertow");
                this.configureIdentityManager(undertowResource);
            }
            case PID: {
                LOG.info("Using \"org.ops4j.pax.url.web\" PID to configure Undertow");
                rootHandler = this.configureUndertow(this.configuration, builder, (HttpHandler)rootHandler);
            }
        }
        for (Context context : this.contextMap.values()) {
            try {
                context.setSessionPersistenceManager(this.sessionPersistenceManager);
                context.setDefaultSessionTimeoutInMinutes(this.defaultSessionTimeoutInMinutes);
                context.start();
            }
            catch (Exception e) {
                LOG.error("Could not start the servlet context for context path [" + context.getContextModel().getContextName() + "]", (Throwable)e);
            }
        }
        builder.setHandler((HttpHandler)rootHandler);
        this.server = builder.build();
    }

    void doStart() {
        this.server.start();
    }

    private void configureIdentityManager(URL undertowResource) {
        try {
            Properties props = new Properties();
            InputStream is = undertowResource.openStream();
            Object object = null;
            try {
                props.load(is);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
            LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
            for (Map.Entry entry : props.entrySet()) {
                config.put(entry.getKey().toString(), entry.getValue().toString());
            }
            this.identityManager = (IdentityManager)this.createConfigurationObject(config, "identityManager");
        }
        catch (Exception e) {
            LOG.error("Exception while starting Undertow", (Throwable)e);
            throw new RuntimeException("Exception while starting Undertow", e);
        }
    }

    private HttpHandler configureUndertow(Configuration configuration, Undertow.Builder builder, HttpHandler rootHandler) {
        if (configuration.isLogNCSAFormatEnabled().booleanValue()) {
            String logNCSADirectory = configuration.getLogNCSADirectory();
            String logNCSAFormat = configuration.getLogNCSAFormat();
            Bundle bundle = FrameworkUtil.getBundle(ServerControllerImpl.class);
            ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            this.xnioWorker = UndertowUtil.createWorker(loader);
            DefaultAccessLogReceiver logReceiver = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)this.xnioWorker).setOutputDirectory(new File(logNCSADirectory).toPath()).setLogBaseName("request.").setLogNameSuffix("log").setRotate(true).build();
            String format = configuration.isLogNCSAExtended() != false ? "combined" : "common";
            rootHandler = new AccessLogHandler(rootHandler, (AccessLogReceiver)logReceiver, format, AccessLogHandler.class.getClassLoader());
        }
        for (String address : configuration.getListeningAddresses()) {
            if (configuration.isHttpEnabled().booleanValue()) {
                LOG.info("Starting undertow http listener on " + address + ":" + configuration.getHttpPort());
                builder.addHttpListener(configuration.getHttpPort().intValue(), address);
            }
            if (!configuration.isHttpSecureEnabled().booleanValue()) continue;
            LOG.info("Starting undertow https listener on " + address + ":" + configuration.getHttpSecurePort());
            SSLContext context = this.buildSSLContext();
            builder.addHttpsListener(configuration.getHttpSecurePort().intValue(), address, context);
        }
        if (configuration.checkForwardedHeaders().booleanValue()) {
            rootHandler = new ProxyPeerAddressHandler(rootHandler);
        }
        return rootHandler;
    }

    private HttpHandler configureUndertow(Configuration configuration, Undertow.Builder builder, HttpHandler rootHandler, URL undertowResource) {
        try {
            ServletContainer.PersistentSessionsConfig persistentSessions;
            SecurityRealm defaultRealm;
            UndertowConfiguration.BindingInfo binding;
            Dictionary externalConfig;
            if (this.jaxb == null) {
                this.jaxb = JAXBContext.newInstance((String)"org.ops4j.pax.web.service.undertow.internal.configuration.model", (ClassLoader)UndertowConfiguration.class.getClassLoader());
            }
            Unmarshaller unmarshaller = this.jaxb.createUnmarshaller();
            UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
            Hashtable properties = new Hashtable();
            if (configuration instanceof ConfigurationSource && (externalConfig = ((ConfigurationSource)configuration).getConfiguration()) != null) {
                Enumeration e = externalConfig.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ((Dictionary)properties).put(key, externalConfig.get(key));
                }
            }
            if (((Dictionary)properties).get("org.osgi.service.http.port") == null && configuration.getHttpPort() != null) {
                ((Dictionary)properties).put("org.osgi.service.http.port", Integer.toString(configuration.getHttpPort()));
            }
            if (((Dictionary)properties).get("org.osgi.service.http.port.secure") == null && configuration.getHttpSecurePort() != null) {
                ((Dictionary)properties).put("org.osgi.service.http.port.secure", Integer.toString(configuration.getHttpSecurePort()));
            }
            final DictionaryPropertyResolver resolver = new DictionaryPropertyResolver(properties, new BundleContextPropertyResolver(this.bundleContext));
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            XMLReader xmlReader = spf.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(new ResolvingContentHandler(new Properties(){

                @Override
                public String getProperty(String key) {
                    return resolver.get(key);
                }

                @Override
                public String getProperty(String key, String defaultValue) {
                    String value = resolver.get(key);
                    return value == null ? defaultValue : value;
                }
            }, (ContentHandler)unmarshallerHandler));
            try (InputStream stream = undertowResource.openStream();){
                xmlReader.parse(new InputSource(stream));
            }
            UndertowConfiguration cfg = (UndertowConfiguration)unmarshallerHandler.getResult();
            if (cfg == null || cfg.getSocketBindings().size() == 0 || cfg.getInterfaces().size() == 0 || cfg.getSubsystem() == null || cfg.getSubsystem().getServer() == null) {
                throw new IllegalArgumentException("Problem configuring Undertow server using \"" + undertowResource + "\": invalid XML");
            }
            cfg.init();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Undertow XML configuration: {}", (Object)cfg);
            }
            Server.HttpListener http = cfg.getSubsystem().getServer().getHttpListener();
            Server.HttpsListener https = cfg.getSubsystem().getServer().getHttpsListener();
            if (http == null && https == null) {
                throw new IllegalArgumentException("No listener configuration available in \"" + undertowResource + "\". Please configure http and/or https listeners.");
            }
            boolean forwardHeaders = false;
            boolean recordRequestStartTime = false;
            boolean peerHostLookup = false;
            if (http != null) {
                binding = cfg.bindingInfo(http.getSocketBindingName());
                for (String string : binding.getAddresses()) {
                    LOG.info("Starting undertow http listener on " + string + ":" + binding.getPort());
                    builder.addHttpListener(binding.getPort(), string);
                    if (http.isRecordRequestStartTime()) {
                        recordRequestStartTime = true;
                    }
                    if ("true".equalsIgnoreCase(http.getProxyAddressForwarding())) {
                        forwardHeaders = true;
                    }
                    if (!"true".equalsIgnoreCase(http.getPeerHostLookup())) continue;
                    peerHostLookup = true;
                }
            }
            if (https != null) {
                binding = cfg.bindingInfo(https.getSocketBindingName());
                SecurityRealm realm = cfg.securityRealm(https.getSecurityRealm());
                if (realm == null) {
                    throw new IllegalArgumentException("No security realm with name \"" + https.getSecurityRealm() + "\" available for \"" + https.getName() + "\" https listener.");
                }
                for (String address : binding.getAddresses()) {
                    LOG.info("Starting undertow https listener on " + address + ":" + binding.getPort());
                    SSLContext sslContext = this.buildSSLContext(realm);
                    builder.addHttpsListener(binding.getPort(), address, sslContext);
                    if (https.isRecordRequestStartTime()) {
                        recordRequestStartTime = true;
                    }
                    if ("true".equalsIgnoreCase(https.getProxyAddressForwarding())) {
                        forwardHeaders = true;
                    }
                    if ("true".equalsIgnoreCase(https.getPeerHostLookup())) {
                        peerHostLookup = true;
                    }
                    builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.valueOf((String)https.getVerifyClient()));
                    SecurityRealm.Engine engine = realm.getIdentities().getSsl().getEngine();
                    if (engine == null) continue;
                    if (engine.getEnabledProtocols().size() > 0) {
                        builder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of(engine.getEnabledProtocols()));
                    }
                    if (engine.getEnabledCipherSuites().size() <= 0) continue;
                    builder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of(engine.getEnabledCipherSuites()));
                }
            }
            builder.setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)recordRequestStartTime);
            if (configuration.getConnectorIdleTimeout() != null) {
                builder.setServerOption(UndertowOptions.IDLE_TIMEOUT, (Object)configuration.getConnectorIdleTimeout());
            }
            if ((defaultRealm = cfg.securityRealm("default")) != null) {
                Iterator<Server.Host.FilterRef> jaasAuth = defaultRealm.getAuthentication().getJaas();
                SecurityRealm.PropertiesAuth propertiesAuth = defaultRealm.getAuthentication().getProperties();
                if (jaasAuth != null) {
                    String userPrincipalClassName = defaultRealm.getUserPrincipalClassName();
                    if (userPrincipalClassName == null || "".equals(userPrincipalClassName.trim())) {
                        userPrincipalClassName = "java.security.Principal";
                    }
                    LinkedHashSet<String> rolePrincipalClassNames = new LinkedHashSet<String>(defaultRealm.getRolePrincipalClassNames());
                    this.identityManager = new JaasIdentityManager(((SecurityRealm.JaasAuth)((Object)jaasAuth)).getName(), userPrincipalClassName, rolePrincipalClassNames);
                } else if (propertiesAuth != null) {
                    File userBase = new File(propertiesAuth.getPath());
                    if (!userBase.isFile()) {
                        throw new IllegalArgumentException(userBase.getCanonicalPath() + " is not accessible. Can't load users/groups information.");
                    }
                    Properties userProperties = new Properties();
                    HashMap<String, String> map = new HashMap<String, String>();
                    try (FileInputStream stream = new FileInputStream(userBase);){
                        userProperties.load(stream);
                        for (String user : userProperties.stringPropertyNames()) {
                            map.put(user, userProperties.getProperty(user));
                        }
                    }
                    this.identityManager = new PropertiesIdentityManager(map);
                }
            }
            if (cfg.getSubsystem().getServer().getHost() != null) {
                for (Server.Host.Location location : cfg.getSubsystem().getServer().getHost().getLocation()) {
                    String context = location.getName();
                    String handlerRef = location.getHandler();
                    UndertowSubsystem.FileHandler fileHandler = cfg.handler(handlerRef);
                    if (fileHandler == null) {
                        throw new IllegalArgumentException("No handler with name \"" + location.getHandler() + "\" available for " + location.getName() + " location.");
                    }
                    File base = new File(fileHandler.getPath());
                    if (!base.isDirectory()) {
                        throw new IllegalArgumentException(base.getCanonicalPath() + " is not accessible. Can't configure handler for " + location.getName() + " location.");
                    }
                    ResourceHandler rh = new ResourceHandler((ResourceManager)new FileResourceManager(base, 4096L));
                    if (cfg.getSubsystem().getServletContainer() != null) {
                        rh.setWelcomeFiles(new String[0]);
                        for (ServletContainer.WelcomeFile wf : cfg.getSubsystem().getServletContainer().getWelcomeFiles()) {
                            rh.addWelcomeFiles(new String[]{wf.getName()});
                        }
                    }
                    if (!(rootHandler instanceof PathHandler)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding resource handler for location \"" + context + "\" and base path \"" + base.getCanonicalPath() + "\".");
                    }
                    ((PathHandler)rootHandler).addPrefixPath(context, (HttpHandler)rh);
                }
            }
            if (cfg.getSubsystem().getServer().getHost() != null) {
                for (Server.Host.FilterRef filterRef : cfg.getSubsystem().getServer().getHost().getFilterRef()) {
                    UndertowSubsystem.AbstractFilter filter = cfg.filter(filterRef.getName());
                    if (filter == null) {
                        throw new IllegalArgumentException("No filter with name \"" + filterRef.getName() + "\" available.");
                    }
                    rootHandler = filter.configure(rootHandler);
                }
            }
            if (cfg.getSubsystem().getServer().getHost() != null && cfg.getSubsystem().getServer().getHost().getAccessLog() != null) {
                Server.Host.AccessLog accessLog = cfg.getSubsystem().getServer().getHost().getAccessLog();
                Bundle bundle = FrameworkUtil.getBundle(ServerControllerImpl.class);
                ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
                this.xnioWorker = UndertowUtil.createWorker(loader);
                DefaultAccessLogReceiver logReceiver = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)this.xnioWorker).setOutputDirectory(new File(accessLog.getDirectory()).toPath()).setLogBaseName(accessLog.getPrefix()).setLogNameSuffix(accessLog.getSuffix()).setRotate(Boolean.parseBoolean(accessLog.getRotate())).build();
                rootHandler = new AccessLogHandler(rootHandler, (AccessLogReceiver)logReceiver, accessLog.getPattern(), AccessLogHandler.class.getClassLoader());
            }
            this.defaultSessionTimeoutInMinutes = 30;
            try {
                String defaultSessionTimeout;
                if (cfg.getSubsystem().getServletContainer() != null && (defaultSessionTimeout = cfg.getSubsystem().getServletContainer().getDefaultSessionTimeout()) != null && !"".equals(defaultSessionTimeout)) {
                    this.defaultSessionTimeoutInMinutes = Integer.parseInt(defaultSessionTimeout);
                }
            }
            catch (NumberFormatException defaultSessionTimeout) {
                // empty catch block
            }
            ServletContainer.PersistentSessionsConfig persistentSessionsConfig = persistentSessions = cfg.getSubsystem().getServletContainer() == null ? null : cfg.getSubsystem().getServletContainer().getPersistentSessions();
            if (persistentSessions == null) {
                LOG.info("Using in-memory session persistence");
                this.sessionPersistenceManager = new InMemorySessionPersistence();
            } else if (persistentSessions.getPath() != null && !"".equals(persistentSessions.getPath().trim())) {
                File file = new File(persistentSessions.getPath());
                file.mkdirs();
                LOG.info("Using file session persistence. Location: " + file.getCanonicalPath());
                this.sessionPersistenceManager = new FileSessionPersistence(file);
            } else {
                LOG.info("No path configured for persistent-sessions. Using in-memory session persistence.");
                this.sessionPersistenceManager = new InMemorySessionPersistence();
            }
            if (forwardHeaders) {
                rootHandler = new ProxyPeerAddressHandler(rootHandler);
            }
            if (peerHostLookup) {
                rootHandler = new PeerNameResolvingHandler(rootHandler);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem configuring Undertow server using \"" + undertowResource + "\": " + e.getMessage(), e);
        }
        return rootHandler;
    }

    private URL detectUndertowConfiguration() {
        URL undertowResource;
        block6: {
            undertowResource = this.configuration.getConfigurationURL();
            File serverConfigDir = this.configuration.getConfigurationDir();
            try {
                if (undertowResource != null || serverConfigDir == null) break block6;
                if (serverConfigDir.isFile() && serverConfigDir.canRead()) {
                    undertowResource = serverConfigDir.toURI().toURL();
                    break block6;
                }
                if (!serverConfigDir.isDirectory()) break block6;
                for (String name : new String[]{"undertow.xml", "undertow.properties"}) {
                    File configuration = new File(serverConfigDir, name);
                    if (!configuration.isFile() || !configuration.canRead()) continue;
                    undertowResource = configuration.toURI().toURL();
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (undertowResource == null) {
            undertowResource = this.getClass().getResource("/undertow.xml");
        }
        if (undertowResource == null) {
            undertowResource = this.getClass().getResource("/undertow.properties");
        }
        return undertowResource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SSLContext buildSSLContext(String keystorePath, String keystoreType, String keystorePassword, String keystoreKeyPassword, String keystoreCertAlias, String truststorePath, String truststoreType, String truststorePassword, boolean validateCerts, String crlPath, String secureRandomAlgorithm, boolean validatePeerCerts, boolean enableCRLDP, boolean enableOCSP, String ocspResponderURL) {
        try {
            SecureRandom random;
            URL keyStoreURL = this.loadResource(keystorePath);
            KeyStore keyStore = this.getKeyStore(keyStoreURL, keystoreType != null ? keystoreType : "JKS", keystorePassword);
            if (keystoreCertAlias != null) {
                KeyStore newKeystore = KeyStore.getInstance(keystoreType != null ? keystoreType : "JKS");
                newKeystore.load(null);
                if (!keyStore.containsAlias(keystoreCertAlias)) throw new IllegalArgumentException("Entry \"keystoreCertAlias\" not found in keystore " + keystorePath);
                KeyStore.PasswordProtection password = new KeyStore.PasswordProtection(keystoreKeyPassword == null ? null : keystoreKeyPassword.toCharArray());
                if (!keyStore.isKeyEntry(keystoreCertAlias)) throw new IllegalArgumentException("Entry \"keystoreCertAlias\" is not private key entry in keystore " + keystorePath);
                KeyStore.Entry entry = keyStore.getEntry(keystoreCertAlias, password);
                newKeystore.setEntry(keystoreCertAlias, entry, password);
                keyStore = newKeystore;
            }
            String _keyManagerFactoryAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? KeyManagerFactory.getDefaultAlgorithm() : Security.getProperty("ssl.KeyManagerFactory.algorithm");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(_keyManagerFactoryAlgorithm);
            keyManagerFactory.init(keyStore, keystoreKeyPassword == null ? null : keystoreKeyPassword.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            SecureRandom secureRandom = random = secureRandomAlgorithm == null ? null : SecureRandom.getInstance(secureRandomAlgorithm);
            if (truststorePath != null) {
                Collection<? extends CRL> crls;
                URL trustStoreURL = this.loadResource(truststorePath);
                KeyStore trustStore = this.getKeyStore(trustStoreURL, truststoreType != null ? truststoreType : "JKS", truststorePassword);
                String _trustManagerFactoryAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? TrustManagerFactory.getDefaultAlgorithm() : Security.getProperty("ssl.TrustManagerFactory.algorithm");
                Collection<? extends CRL> collection = crls = crlPath == null ? null : this.loadCRL(crlPath);
                if (validateCerts && keyStore != null) {
                    Certificate cert;
                    if (keystoreCertAlias == null) {
                        ArrayList<String> aliases = Collections.list(keyStore.aliases());
                        keystoreCertAlias = aliases.size() == 1 ? (String)aliases.get(0) : null;
                    }
                    Certificate certificate = cert = keystoreCertAlias == null ? null : keyStore.getCertificate(keystoreCertAlias);
                    if (cert == null) {
                        throw new IllegalArgumentException("No certificate found in the keystore" + (keystoreCertAlias == null ? "" : " for alias \"" + keystoreCertAlias + "\""));
                    }
                    CertificateValidator validator = new CertificateValidator(trustStore, crls);
                    validator.setEnableCRLDP(enableCRLDP);
                    validator.setEnableOCSP(enableOCSP);
                    validator.setOcspResponderURL(ocspResponderURL);
                    validator.validate(keyStore, cert);
                }
                if (validatePeerCerts && _trustManagerFactoryAlgorithm.equalsIgnoreCase("PKIX")) {
                    PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                    pbParams.setRevocationEnabled(true);
                    if (crls != null && !crls.isEmpty()) {
                        pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                    }
                    if (enableCRLDP) {
                        System.setProperty("com.sun.security.enableCRLDP", "true");
                    }
                    if (enableOCSP) {
                        Security.setProperty("ocsp.enable", "true");
                        if (ocspResponderURL != null) {
                            Security.setProperty("ocsp.responderURL", ocspResponderURL);
                        }
                    }
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(_trustManagerFactoryAlgorithm);
                    trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                    trustManagers = trustManagerFactory.getTrustManagers();
                } else {
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(_trustManagerFactoryAlgorithm);
                    trustManagerFactory.init(trustStore);
                    trustManagers = trustManagerFactory.getTrustManagers();
                }
            }
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagers, trustManagers, random);
            return context;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to build SSL context", e);
        }
    }

    private SSLContext buildSSLContext() {
        String keyANDkeystorePassword = this.configuration.getSslKeyPassword() == null ? this.configuration.getSslPassword() : this.configuration.getSslKeyPassword();
        return this.buildSSLContext(this.configuration.getSslKeystore(), this.configuration.getSslKeystoreType(), keyANDkeystorePassword, keyANDkeystorePassword, this.configuration.getSslKeyAlias(), this.configuration.getTrustStore(), this.configuration.getTrustStoreType(), this.configuration.getTrustStorePassword(), this.configuration.isValidateCerts(), this.configuration.getCrlPath(), null, this.configuration.isValidatePeerCerts(), this.configuration.isEnableCRLDP(), this.configuration.isEnableOCSP(), this.configuration.getOcspResponderURL());
    }

    private SSLContext buildSSLContext(SecurityRealm realm) {
        if (realm.getAuthentication() == null || realm.getAuthentication().getTruststore() == null) {
            throw new IllegalArgumentException("No truststore configuration in security realm \"" + realm.getName() + "\".");
        }
        if (realm.getIdentities() == null || realm.getIdentities().getSsl() == null || realm.getIdentities().getSsl().getKeystore() == null) {
            throw new IllegalArgumentException("No keystore configuration in security realm \"" + realm.getName() + "\".");
        }
        SecurityRealm.Keystore keystore = realm.getIdentities().getSsl().getKeystore();
        SecurityRealm.Truststore truststore = realm.getAuthentication().getTruststore();
        String keystorePassword = keystore.getPassword();
        String keyPassword = keystore.getKeyPassword();
        return this.buildSSLContext(keystore.getPath(), keystore.getProvider(), keystorePassword, keyPassword, keystore.getAlias(), truststore.getPath(), truststore.getProvider(), truststore.getPassword(), this.configuration.isValidateCerts(), this.configuration.getCrlPath(), null, this.configuration.isValidatePeerCerts(), this.configuration.isEnableCRLDP(), this.configuration.isEnableOCSP(), this.configuration.getOcspResponderURL());
    }

    private URL loadResource(String resource) throws MalformedURLException {
        URL url;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                try {
                    File file = new File(resource).getCanonicalFile();
                    url = file.toURI().toURL();
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
        return url;
    }

    private KeyStore getKeyStore(URL storePath, String storeType, String storePassword) throws Exception {
        KeyStore keystore = KeyStore.getInstance(storeType);
        try (InputStream is = storePath.openStream();){
            keystore.load(is, storePassword.toCharArray());
        }
        return keystore;
    }

    private Object createConfigurationObject(Map<String, String> config, String name) throws Exception {
        String clazzName = config.get(name);
        if (clazzName != null) {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(clazzName);
            Constructor<?> cns = clazz.getDeclaredConstructor(Map.class);
            HashMap<String, String> subCfg = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : config.entrySet()) {
                if (!entry.getKey().startsWith(name + ".")) continue;
                subCfg.put(entry.getKey().substring(name.length() + 1), entry.getValue());
            }
            return cns.newInstance(subCfg);
        }
        return null;
    }

    void doStop() {
        if (this.xnioWorker != null) {
            this.xnioWorker.shutdown();
        }
        this.server.stop();
    }

    public synchronized LifeCycle getContext(ContextModel model) {
        this.assertNotState(State.Unconfigured);
        return this.findOrCreateContext(model);
    }

    public synchronized void removeContext(HttpContext httpContext) {
        this.assertNotState(State.Unconfigured);
        Context context = (Context)this.contextMap.remove(httpContext);
        if (context == null) {
            throw new IllegalStateException("Cannot remove the context because it does not exist: " + httpContext);
        }
        context.destroy();
    }

    private void assertState(State state) {
        if (this.state != state) {
            throw new IllegalStateException("State is " + (Object)((Object)this.state) + " but should be " + (Object)((Object)state));
        }
    }

    private void assertNotState(State state) {
        if (this.state == state) {
            throw new IllegalStateException("State should not be " + (Object)((Object)this.state));
        }
    }

    private Context findContext(ContextModel contextModel) {
        NullArgumentException.validateNotNull(contextModel, "contextModel");
        WebContainerContext httpContext = contextModel.getHttpContext();
        return (Context)this.contextMap.get(httpContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context findOrCreateContext(ContextModel contextModel) {
        NullArgumentException.validateNotNull(contextModel, "contextModel");
        ConcurrentMap<HttpContext, Context> concurrentMap = this.contextMap;
        synchronized (concurrentMap) {
            if (this.contextMap.containsKey(contextModel.getHttpContext())) {
                return (Context)this.contextMap.get(contextModel.getHttpContext());
            }
            Context newCtx = new Context(this, this.path, contextModel);
            newCtx.setConfiguration(this.configuration);
            newCtx.setDefaultSessionTimeoutInMinutes(this.defaultSessionTimeoutInMinutes);
            newCtx.setSessionPersistenceManager(this.sessionPersistenceManager);
            this.contextMap.put((HttpContext)contextModel.getHttpContext(), newCtx);
            Servlet servlet = this.createResourceServlet(contextModel, "/", "default");
            ResourceModel model = new ResourceModel(contextModel, servlet, "/", "default");
            try {
                newCtx.addServlet((ServletModel)model);
            }
            catch (ServletException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
            return newCtx;
        }
    }

    public synchronized void addServlet(ServletModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addServlet(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add servlet", e);
        }
    }

    public void removeServlet(ServletModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findContext(model.getContextModel());
            if (context != null) {
                context.removeServlet(model);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to remove servlet", e);
        }
    }

    public void addEventListener(EventListenerModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addEventListener(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add event listener", e);
        }
    }

    public void removeEventListener(EventListenerModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.removeEventListener(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add event listener", e);
        }
    }

    public void addFilter(FilterModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addFilter(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add filter", e);
        }
    }

    public void removeFilter(FilterModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.removeFilter(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to remove filter", e);
        }
    }

    public void addErrorPage(ErrorPageModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addErrorPage(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add error page", e);
        }
    }

    public void removeErrorPage(ErrorPageModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.removeErrorPage(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to remove error page", e);
        }
    }

    public void addWelcomFiles(WelcomeFileModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addWelcomeFile(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add welcome files", e);
        }
    }

    public void removeWelcomeFiles(WelcomeFileModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.removeWelcomeFile(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add welcome files", e);
        }
    }

    public Servlet createResourceServlet(ContextModel contextModel, String alias, String name) {
        Context context = this.findOrCreateContext(contextModel);
        return new ResourceServlet(context, alias, name);
    }

    public void addSecurityConstraintMapping(SecurityConstraintMappingModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addSecurityConstraintMapping(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add welcome files", e);
        }
    }

    public void removeSecurityConstraintMapping(SecurityConstraintMappingModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.removeSecurityConstraintMapping(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add welcome files", e);
        }
    }

    public void addContainerInitializerModel(ContainerInitializerModel model) {
        this.assertNotState(State.Unconfigured);
        try {
            Context context = this.findOrCreateContext(model.getContextModel());
            context.addContainerInitializerModel(model);
        }
        catch (ServletException e) {
            throw new RuntimeException("Unable to add welcome files", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        Collection<? extends CRL> crlList = null;
        if (crlPath != null) {
            try (InputStream in = null;){
                in = this.loadResource(crlPath).openStream();
                crlList = CertificateFactory.getInstance("X.509").generateCRLs(in);
            }
        }
        return crlList;
    }

    public Account verify(Account account) {
        if (this.identityManager != null) {
            return this.identityManager.verify(account);
        }
        throw new IllegalStateException("No identity manager configured");
    }

    public Account verify(String id, Credential credential) {
        if (this.identityManager != null) {
            return this.identityManager.verify(id, credential);
        }
        throw new IllegalStateException("No identity manager configured");
    }

    public Account verify(Credential credential) {
        if (this.identityManager != null) {
            return this.identityManager.verify(credential);
        }
        throw new IllegalStateException("No identity manager configured");
    }

    private static enum ConfigSource {
        XML,
        PROPERTIES,
        PID;


        public static ConfigSource kind(URL undertowResource) {
            if (undertowResource == null) {
                return PID;
            }
            String path = undertowResource.getPath();
            if (path == null) {
                return PID;
            }
            String name = new File(path).getName();
            if (name.endsWith(".properties")) {
                return PROPERTIES;
            }
            if (name.endsWith(".xml")) {
                return XML;
            }
            return PID;
        }
    }

    private static enum State {
        Unconfigured,
        Stopped,
        Started;

    }
}

