/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.spi.ForwardingReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.WriteTrackingTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class WriteTrackingReadWriteTransaction
extends ForwardingReadWriteTransaction
implements WriteTrackingTransaction {
    private volatile boolean written;

    WriteTrackingReadWriteTransaction(ReadWriteTransaction delegate) {
        super(delegate);
    }

    public <T extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        super.put(store, path, data);
        this.written = true;
    }

    public <T extends DataObject> void mergeParentStructurePut(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        super.mergeParentStructurePut(store, path, data);
        this.written = true;
    }

    public <T extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        super.merge(store, path, data);
        this.written = true;
    }

    public <T extends DataObject> void mergeParentStructureMerge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        super.mergeParentStructureMerge(store, path, data);
        this.written = true;
    }

    public void delete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        super.delete(store, path);
        this.written = true;
    }

    @Override
    public boolean isWritten() {
        return this.written;
    }
}

