/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public abstract class RpcRoutingStrategy
implements Identifiable<QName> {
    private static final QName CONTEXT_REFERENCE = QName.create((String)"urn:opendaylight:yang:extension:yang-ext", (String)"2013-07-09", (String)"context-reference").intern();
    private final QName identifier;

    private RpcRoutingStrategy(QName identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    public abstract QName getLeaf();

    public abstract QName getContext();

    public final QName getIdentifier() {
        return this.identifier;
    }

    public abstract boolean isContextBasedRouted();

    public static RpcRoutingStrategy from(RpcDefinition rpc) {
        for (DataSchemaNode schemaNode : rpc.getInput().getChildNodes()) {
            Optional<QName> context = RpcRoutingStrategy.getRoutingContext(schemaNode);
            if (!context.isPresent()) continue;
            return new RoutedRpcStrategy(rpc.getQName(), context.get(), schemaNode.getQName());
        }
        return new GlobalRpcStrategy(rpc.getQName());
    }

    public static Optional<QName> getRoutingContext(DataSchemaNode schemaNode) {
        for (UnknownSchemaNode extension : schemaNode.getUnknownSchemaNodes()) {
            if (!CONTEXT_REFERENCE.equals((Object)extension.getNodeType())) continue;
            return Optional.ofNullable(extension.getQName());
        }
        return Optional.empty();
    }

    private static final class GlobalRpcStrategy
    extends RpcRoutingStrategy {
        GlobalRpcStrategy(QName identifier) {
            super(identifier);
        }

        @Override
        public boolean isContextBasedRouted() {
            return false;
        }

        @Override
        public QName getContext() {
            throw new UnsupportedOperationException("Non-routed strategy does not have a context");
        }

        @Override
        public QName getLeaf() {
            throw new UnsupportedOperationException("Non-routed strategy does not have a context");
        }
    }

    private static final class RoutedRpcStrategy
    extends RpcRoutingStrategy {
        private final QName context;
        private final QName leaf;

        private RoutedRpcStrategy(QName identifier, QName ctx, QName leaf) {
            super(identifier);
            this.context = Objects.requireNonNull(ctx);
            this.leaf = Objects.requireNonNull(leaf);
        }

        @Override
        public QName getContext() {
            return this.context;
        }

        @Override
        public QName getLeaf() {
            return this.leaf;
        }

        @Override
        public boolean isContextBasedRouted() {
            return true;
        }
    }
}

