/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class SimpleDOMMountPoint
implements DOMMountPoint {
    private final YangInstanceIdentifier identifier;
    private final ClassToInstanceMap<DOMService> services;
    private final EffectiveModelContext schemaContext;

    private SimpleDOMMountPoint(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services, EffectiveModelContext ctx) {
        this.identifier = Objects.requireNonNull(identifier);
        this.services = ImmutableClassToInstanceMap.copyOf(services);
        this.schemaContext = ctx;
    }

    public static SimpleDOMMountPoint create(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services, EffectiveModelContext ctx) {
        return new SimpleDOMMountPoint(identifier, services, ctx);
    }

    public YangInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public EffectiveModelContext getEffectiveModelContext() {
        Preconditions.checkState((this.schemaContext != null ? 1 : 0) != 0, (String)"Mount point %s does not have a model context", (Object)this.identifier);
        return this.schemaContext;
    }

    public <T extends DOMService> Optional<T> getService(Class<T> cls) {
        return Optional.ofNullable((DOMService)this.services.getInstance(cls));
    }
}

