/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;

@Beta
public abstract class AbstractStateAggregator<S extends State> {
    private volatile Behavior<?, S> behavior;

    protected AbstractStateAggregator(int sizeHint) {
        this.behavior = new Starting(sizeHint);
    }

    protected final void addBuilder(StateBuilder<S> builder) {
        this.checkStarting().add(builder);
    }

    protected final synchronized Started<S> start(Function<Collection<StateBuilder<S>>, Started<S>> function) {
        Started<S> ret = this.checkStarting().start(function);
        this.behavior = ret;
        return ret;
    }

    protected final void receiveState(StateBuilder<S> builder, S state) {
        this.behavior.receiveState(builder, state);
    }

    private Starting<S> checkStarting() {
        Behavior<?, S> local = this.behavior;
        Preconditions.checkState((boolean)(local instanceof Starting), (String)"Unexpected behavior %s", local);
        return (Starting)local;
    }

    protected static abstract class Operational<S extends State>
    extends Started<S> {
        private final AtomicBoolean semaphore = new AtomicBoolean();
        private final AtomicLong generation = new AtomicLong();
        private volatile long processed;

        protected Operational(Collection<? extends StateBuilder<S>> builders) {
            super(builders);
        }

        protected abstract void notifyListener(Iterator<S> var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void receiveState(StateBuilder<S> builder, S state) {
            StateBuilder<S> stateBuilder = builder;
            synchronized (stateBuilder) {
                long gen = this.generation.incrementAndGet();
                try {
                    builder.append(state);
                }
                finally {
                    this.tryNotifyListener(gen);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryNotifyListener(long initGen) {
            long gen = initGen;
            while (gen != this.processed && this.semaphore.compareAndSet(false, true)) {
                try {
                    this.processed = gen;
                    this.notifyListener(Iterators.transform(this.builders().iterator(), Builder::build));
                }
                finally {
                    this.semaphore.set(false);
                }
                long nextGen = this.generation.get();
                if (nextGen == gen) {
                    return;
                }
                gen = nextGen;
            }
        }
    }

    protected static final class Failed<S extends State>
    extends Started<S> {
        protected Failed(Collection<? extends StateBuilder<S>> builders) {
            super(builders);
        }

        @Override
        void receiveState(StateBuilder<S> builder, S state) {
        }
    }

    protected static abstract class Started<S extends State>
    extends Behavior<Started<S>, S> {
        private final Collection<StateBuilder<S>> builders;

        Started(Collection<? extends StateBuilder<S>> builders) {
            this.builders = ImmutableList.copyOf(builders);
        }

        @Override
        final Collection<StateBuilder<S>> builders() {
            return this.builders;
        }
    }

    private static final class Starting<S extends State>
    extends Behavior<Starting<S>, S> {
        private final Collection<StateBuilder<S>> builders;
        private @GuardedBy(value={"this"}) Started<S> successor;

        Starting(int sizeHint) {
            this.builders = new ArrayList<StateBuilder<S>>(sizeHint);
        }

        void add(StateBuilder<S> builder) {
            this.builders.add(Objects.requireNonNull(builder));
        }

        @Override
        Collection<StateBuilder<S>> builders() {
            return this.builders;
        }

        @Override
        synchronized void receiveState(StateBuilder<S> builder, S state) {
            if (this.successor != null) {
                this.successor.receiveState(builder, state);
                return;
            }
            builder.appendInitial(state);
        }

        synchronized Started<S> start(Function<Collection<StateBuilder<S>>, Started<S>> function) {
            Started next;
            Preconditions.checkState((this.successor == null ? 1 : 0) != 0, (Object)"Attempted to start an already-started aggregator");
            this.successor = next = (Started)Verify.verifyNotNull(function.apply((Collection<StateBuilder<S>>)ImmutableList.copyOf(this.builders)));
            return next;
        }
    }

    protected static abstract class Behavior<B extends Behavior<B, S>, S extends State> {
        protected Behavior() {
        }

        abstract Collection<StateBuilder<S>> builders();

        abstract void receiveState(StateBuilder<S> var1, S var2);
    }

    protected static abstract class StateBuilder<S extends State>
    implements Builder<S>,
    Mutable {
        protected StateBuilder() {
        }

        protected abstract void append(S var1);

        protected abstract void appendInitial(S var1);
    }

    public static abstract class State
    implements Immutable {
    }
}

