/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.AccessLog;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.tomcat.util.digester.Digester;
import org.ops4j.pax.web.jsp.JspServletWrapper;
import org.ops4j.pax.web.service.WebContainerContext;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.tomcat.internal.ContextSelectionHostValve;
import org.ops4j.pax.web.service.tomcat.internal.HttpServiceContext;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class EmbeddedTomcat
extends Tomcat {
    public static final String SERVER_CONFIG_FILE_NAME = "tomcat-server.xml";
    private static final String[] DEFAULT_MIME_MAPPINGS = new String[]{"abs", "audio/x-mpeg", "ai", "application/postscript", "aif", "audio/x-aiff", "aifc", "audio/x-aiff", "aiff", "audio/x-aiff", "aim", "application/x-aim", "art", "image/x-jg", "asf", "video/x-ms-asf", "asx", "video/x-ms-asf", "au", "audio/basic", "avi", "video/x-msvideo", "avx", "video/x-rad-screenplay", "bcpio", "application/x-bcpio", "bin", "application/octet-stream", "bmp", "image/bmp", "body", "text/html", "cdf", "application/x-cdf", "cer", "application/pkix-cert", "class", "application/java", "cpio", "application/x-cpio", "csh", "application/x-csh", "css", "text/css", "dib", "image/bmp", "doc", "application/msword", "dtd", "application/xml-dtd", "dv", "video/x-dv", "dvi", "application/x-dvi", "eps", "application/postscript", "etx", "text/x-setext", "exe", "application/octet-stream", "gif", "image/gif", "gtar", "application/x-gtar", "gz", "application/x-gzip", "hdf", "application/x-hdf", "hqx", "application/mac-binhex40", "htc", "text/x-component", "htm", "text/html", "html", "text/html", "ief", "image/ief", "jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive", "java", "text/x-java-source", "jnlp", "application/x-java-jnlp-file", "jpe", "image/jpeg", "jpeg", "image/jpeg", "jpg", "image/jpeg", "js", "application/javascript", "jsf", "text/plain", "jspf", "text/plain", "kar", "audio/midi", "latex", "application/x-latex", "m3u", "audio/x-mpegurl", "mac", "image/x-macpaint", "man", "text/troff", "mathml", "application/mathml+xml", "me", "text/troff", "mid", "audio/midi", "midi", "audio/midi", "mif", "application/x-mif", "mov", "video/quicktime", "movie", "video/x-sgi-movie", "mp1", "audio/mpeg", "mp2", "audio/mpeg", "mp3", "audio/mpeg", "mp4", "video/mp4", "mpa", "audio/mpeg", "mpe", "video/mpeg", "mpeg", "video/mpeg", "mpega", "audio/x-mpeg", "mpg", "video/mpeg", "mpv2", "video/mpeg2", "nc", "application/x-netcdf", "oda", "application/oda", "odb", "application/vnd.oasis.opendocument.database", "odc", "application/vnd.oasis.opendocument.chart", "odf", "application/vnd.oasis.opendocument.formula", "odg", "application/vnd.oasis.opendocument.graphics", "odi", "application/vnd.oasis.opendocument.image", "odm", "application/vnd.oasis.opendocument.text-master", "odp", "application/vnd.oasis.opendocument.presentation", "ods", "application/vnd.oasis.opendocument.spreadsheet", "odt", "application/vnd.oasis.opendocument.text", "otg", "application/vnd.oasis.opendocument.graphics-template", "oth", "application/vnd.oasis.opendocument.text-web", "otp", "application/vnd.oasis.opendocument.presentation-template", "ots", "application/vnd.oasis.opendocument.spreadsheet-template ", "ott", "application/vnd.oasis.opendocument.text-template", "ogx", "application/ogg", "ogv", "video/ogg", "oga", "audio/ogg", "ogg", "audio/ogg", "spx", "audio/ogg", "flac", "audio/flac", "anx", "application/annodex", "axa", "audio/annodex", "axv", "video/annodex", "xspf", "application/xspf+xml", "pbm", "image/x-portable-bitmap", "pct", "image/pict", "pdf", "application/pdf", "pgm", "image/x-portable-graymap", "pic", "image/pict", "pict", "image/pict", "pls", "audio/x-scpls", "png", "image/png", "pnm", "image/x-portable-anymap", "pnt", "image/x-macpaint", "ppm", "image/x-portable-pixmap", "ppt", "application/vnd.ms-powerpoint", "pps", "application/vnd.ms-powerpoint", "ps", "application/postscript", "psd", "image/vnd.adobe.photoshop", "qt", "video/quicktime", "qti", "image/x-quicktime", "qtif", "image/x-quicktime", "ras", "image/x-cmu-raster", "rdf", "application/rdf+xml", "rgb", "image/x-rgb", "rm", "application/vnd.rn-realmedia", "roff", "text/troff", "rtf", "application/rtf", "rtx", "text/richtext", "sh", "application/x-sh", "shar", "application/x-shar", "sit", "application/x-stuffit", "snd", "audio/basic", "src", "application/x-wais-source", "sv4cpio", "application/x-sv4cpio", "sv4crc", "application/x-sv4crc", "svg", "image/svg+xml", "svgz", "image/svg+xml", "swf", "application/x-shockwave-flash", "t", "text/troff", "tar", "application/x-tar", "tcl", "application/x-tcl", "tex", "application/x-tex", "texi", "application/x-texinfo", "texinfo", "application/x-texinfo", "tif", "image/tiff", "tiff", "image/tiff", "tr", "text/troff", "tsv", "text/tab-separated-values", "txt", "text/plain", "ulw", "audio/basic", "ustar", "application/x-ustar", "vxml", "application/voicexml+xml", "xbm", "image/x-xbitmap", "xht", "application/xhtml+xml", "xhtml", "application/xhtml+xml", "xls", "application/vnd.ms-excel", "xml", "application/xml", "xpm", "image/x-xpixmap", "xsl", "application/xml", "xslt", "application/xslt+xml", "xul", "application/vnd.mozilla.xul+xml", "xwd", "image/x-xwindowdump", "vsd", "application/vnd.visio", "wav", "audio/x-wav", "wbmp", "image/vnd.wap.wbmp", "wml", "text/vnd.wap.wml", "wmlc", "application/vnd.wap.wmlc", "wmls", "text/vnd.wap.wmlsc", "wmlscriptc", "application/vnd.wap.wmlscriptc", "wmv", "video/x-ms-wmv", "wrl", "model/vrml", "wspolicy", "application/wspolicy+xml", "Z", "application/x-compress", "z", "application/x-compress", "zip", "application/zip"};
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedTomcat.class);
    private Integer configurationSessionTimeout;
    private String configurationSessionCookie;
    private Integer configurationSessionCookieMaxAge;
    private Boolean configurationSessionCookieHttpOnly;
    private File configurationDir;

    private EmbeddedTomcat() {
    }

    static EmbeddedTomcat newEmbeddedTomcat(Configuration configuration) {
        EmbeddedTomcat result = new EmbeddedTomcat();
        result.configure(configuration);
        return result;
    }

    public void setServer(Server server) {
        this.server = server;
        Service[] findServices = server.findServices();
        if (findServices != null && findServices.length > 0 && findServices[0].getContainer() == null) {
            this.getEngine().setName("Catalina");
        }
    }

    /*
     * Unable to fully structure code
     */
    void configure(Configuration configuration) {
        start = System.nanoTime();
        digester = new FakeCatalina().createStartDigester();
        digester.push((Object)this);
        tomcatResource = configuration.getConfigurationURL();
        if (tomcatResource == null) {
            tomcatResource = this.getClass().getResource("/tomcat-server.xml");
        }
        this.configurationDir = configuration.getConfigurationDir();
        configurationFile = new File(this.configurationDir, "tomcat-server.xml");
        if (configurationFile.exists()) {
            try {
                tomcatResource = configurationFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                EmbeddedTomcat.LOG.error("Exception while starting Tomcat:", (Throwable)e);
                throw new RuntimeException("Exception while starting Tomcat", e);
            }
        }
        if (tomcatResource != null) {
            loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                EmbeddedTomcat.LOG.debug("Configure using resource " + tomcatResource);
                digester.parse(tomcatResource.openStream());
                elapsed = start - System.nanoTime();
                if (!EmbeddedTomcat.LOG.isInfoEnabled()) ** GOTO lbl36
                EmbeddedTomcat.LOG.info("configuration processed in {} ms", (Object)(elapsed / 1000000L));
            }
            catch (IOException | SAXException e) {
                EmbeddedTomcat.LOG.error("Exception while starting Tomcat:", (Throwable)e);
                throw new RuntimeException("Exception while starting Tomcat", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        } else {
            this.getServer().setCatalina((Catalina)new FakeCatalina());
            this.getService().setName("Catalina");
            this.getEngine().setName("Catalina");
        }
lbl36:
        // 3 sources

        this.mergeConfiguration(configuration);
        this.initBaseDir(configuration);
    }

    private void mergeConfiguration(Configuration configuration) {
        LOG.debug("Start merging configuration");
        Connector httpConnector = null;
        Connector httpSecureConnector = null;
        String[] addresses = configuration.getListeningAddresses();
        if (addresses == null || addresses.length == 0) {
            addresses = new String[]{null};
        }
        this.configurationSessionTimeout = configuration.getSessionTimeout();
        this.configurationSessionCookie = configuration.getSessionCookie();
        this.configurationSessionCookieMaxAge = configuration.getSessionCookieMaxAge();
        this.configurationSessionCookieHttpOnly = configuration.getSessionCookieHttpOnly();
        if (configuration.isLogNCSAFormatEnabled().booleanValue()) {
            AccessLogValve ncsaLogger = new AccessLogValve();
            boolean modifiedValve = false;
            for (Valve valve : this.getHost().getPipeline().getValves()) {
                if (!(valve instanceof AccessLogValve)) continue;
                modifiedValve = true;
                ncsaLogger = (AccessLog)valve;
            }
            ncsaLogger.setPattern("common");
            ncsaLogger.setDirectory(configuration.getLogNCSADirectory());
            ncsaLogger.setSuffix(".log");
            if (!modifiedValve) {
                this.getHost().getPipeline().addValve((Valve)ncsaLogger);
            }
        }
        Integer httpPort = configuration.getHttpPort();
        Integer httpSecurePort = configuration.getHttpSecurePort();
        Integer idleTimeout = configuration.getConnectorIdleTimeout();
        for (String address : addresses) {
            Connector[] connectors;
            if (configuration.isHttpEnabled().booleanValue()) {
                LOG.debug("HttpEnabled");
                connectors = this.getService().findConnectors();
                boolean masterConnectorFound = false;
                if (connectors != null && connectors.length > 0) {
                    Connector backupConnector = null;
                    for (Connector connector : connectors) {
                        if (connector.getSecure()) continue;
                        if (this.matches(address, httpPort, connector)) {
                            if (httpConnector == null) {
                                httpConnector = connector;
                            }
                            masterConnectorFound = true;
                            LOG.debug("master connector found, will alter it");
                            continue;
                        }
                        if (backupConnector != null) continue;
                        backupConnector = connector;
                        LOG.debug("backup connector found");
                    }
                    if (httpConnector == null && backupConnector != null) {
                        LOG.debug("No master connector found will use backup one");
                        httpConnector = backupConnector;
                    }
                }
                if (!masterConnectorFound) {
                    httpConnector = this.createConnector(configuration, httpConnector, address, httpPort, idleTimeout);
                }
            } else {
                LOG.debug("Http is disabled any existing http connector will be removed");
                connectors = this.getService().findConnectors();
                if (connectors != null) {
                    for (Connector connector : connectors) {
                        if (connector.getSecure()) continue;
                        LOG.debug("Removing connector {}", (Object)connector);
                        this.getService().removeConnector(connector);
                    }
                }
            }
            if (configuration.isHttpSecureEnabled().booleanValue()) {
                String sslPassword = configuration.getSslKeystorePassword();
                String sslKeyPassword = configuration.getSslKeyPassword();
                Connector[] connectors2 = this.getService().findConnectors();
                boolean masterSSLConnectorFound = false;
                if (connectors2 != null && connectors2.length > 0) {
                    Connector backupConnector = null;
                    for (Connector connector : connectors2) {
                        if (!connector.getSecure()) continue;
                        Connector sslCon = connector;
                        if (this.matches(address, httpSecurePort, connector)) {
                            httpSecureConnector = sslCon;
                            masterSSLConnectorFound = true;
                            continue;
                        }
                        if (backupConnector != null) continue;
                        backupConnector = connector;
                    }
                    if (httpSecureConnector == null && backupConnector != null) {
                        httpSecureConnector = backupConnector;
                    }
                }
                if (masterSSLConnectorFound) continue;
                httpSecureConnector = this.createSSLConnector(configuration, httpSecureConnector, address, httpSecurePort, sslPassword, sslKeyPassword);
                continue;
            }
            connectors = this.getService().findConnectors();
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                if (!connector.getSecure()) continue;
                this.getService().removeConnector(connector);
            }
        }
    }

    private boolean matches(String address, Integer port, Connector connector) {
        InetSocketAddress isa1 = address != null ? new InetSocketAddress(address, (int)port) : new InetSocketAddress(port);
        InetSocketAddress isa2 = connector.getAttribute("address") != null ? new InetSocketAddress(connector.getAttribute("address").toString(), connector.getPort()) : new InetSocketAddress(connector.getPort());
        return isa1.equals(isa2) && connector.getProtocol() != null && connector.getProtocol().toLowerCase(Locale.ROOT).startsWith("http");
    }

    private Connector createSSLConnector(Configuration configuration, Connector httpSecureConnector, String address, Integer httpSecurePort, String sslPassword, String sslKeyPassword) {
        Connector secureConnector = null;
        if (sslPassword != null && sslKeyPassword != null) {
            secureConnector = new Connector("HTTP/1.1");
            secureConnector.setPort(httpSecurePort.intValue());
            secureConnector.setSecure(true);
            secureConnector.setScheme("https");
            secureConnector.setProperty("SSLEnabled", "true");
            secureConnector.setProperty("keystoreFile", configuration.getSslKeystore());
            secureConnector.setProperty("keystorePass", configuration.getSslKeyPassword());
            secureConnector.setProperty("clientAuth", "false");
            secureConnector.setProperty("sslProtocol", "TLS");
            if (configuration.getServerMaxThreads() != null) {
                secureConnector.setAttribute("maxThreads", (Object)configuration.getServerMaxThreads());
            }
            if (configuration.getServerMinThreads() != null) {
                secureConnector.setAttribute("minSpareThreads", (Object)configuration.getServerMinThreads());
            }
            if (address != null) {
                secureConnector.setAttribute("address", (Object)address);
            }
            this.getService().addConnector(secureConnector);
        } else {
            LOG.warn("SSL password and SSL keystore password must be set in order to enable SSL.");
            LOG.warn("SSL connector will not be started");
        }
        return httpSecureConnector == null ? secureConnector : httpSecureConnector;
    }

    private Connector createConnector(Configuration configuration, Connector httpConnector, String address, Integer httpPort, Integer idleTimeout) {
        LOG.debug("No Master connector found create a new one");
        Connector connector = new Connector("HTTP/1.1");
        LOG.debug("Reconfiguring master connector");
        LOG.debug("Configuring connector {}", (Object)connector);
        connector.setScheme("http");
        connector.setPort(httpPort.intValue());
        if (configuration.isHttpSecureEnabled().booleanValue()) {
            connector.setRedirectPort(configuration.getHttpSecurePort().intValue());
        }
        if (configuration.getServerMaxThreads() != null) {
            connector.setAttribute("maxThreads", (Object)configuration.getServerMaxThreads());
        }
        if (configuration.getServerMinThreads() != null) {
            connector.setAttribute("minSpareThreads", (Object)configuration.getServerMinThreads());
        }
        if (address != null) {
            connector.setAttribute("address", (Object)address);
        }
        if (idleTimeout != null) {
            connector.setProperty("connectionTimeout", idleTimeout.toString());
        }
        LOG.debug("configuration done: {}", (Object)connector);
        this.getService().addConnector(connector);
        return httpConnector == null ? connector : httpConnector;
    }

    private void initBaseDir(Configuration configuration) {
        if (System.getProperty("catalina.home") == null) {
            this.setBaseDir(configuration.getTemporaryDirectory().getAbsolutePath());
        }
        this.initBaseDir();
    }

    String getBasedir() {
        return this.basedir;
    }

    File getConfigurationDir() {
        return this.configurationDir;
    }

    public Context findContext(ContextModel contextModel) {
        String name = this.generateContextName(contextModel.getContextName(), (HttpContext)contextModel.getHttpContext());
        return this.findContext(name);
    }

    Context findContext(String contextName) {
        return (Context)this.findContainer(contextName);
    }

    Container findContainer(String contextName) {
        return this.getHost().findChild(contextName);
    }

    public Context addContext(Map<String, String> contextParams, Map<String, Object> contextAttributes, String contextName, WebContainerContext httpContext, AccessControlContext accessControllerContext, Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers, URL jettyWebXmlURL, List<String> virtualHosts, List<String> connectors, String basedir) {
        this.silence("/" + contextName);
        HttpServiceContext ctx = new HttpServiceContext(this.getHost(), accessControllerContext);
        String name = this.generateContextName(contextName, (HttpContext)httpContext);
        LOG.info("registering context {}, with context-name: {}", (Object)httpContext, (Object)name);
        ctx.setWebappVersion(name);
        ctx.setName(name);
        ctx.setPath("/" + contextName);
        ctx.setDocBase(basedir);
        ctx.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        ctx.setSessionCookieName(this.configurationSessionCookie);
        ctx.setUseHttpOnly(this.configurationSessionCookieHttpOnly);
        ctx.setSessionTimeout(this.configurationSessionTimeout);
        ctx.setHttpContext(httpContext);
        ctx.setContextAttributes(contextAttributes);
        if (containerInitializers != null) {
            for (Map.Entry<ServletContainerInitializer, Set<Class<?>>> entry : containerInitializers.entrySet()) {
                ctx.addServletContainerInitializer(entry.getKey(), entry.getValue());
            }
        }
        if (this.isJspAvailable()) {
            try {
                Class<?> loadClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.ops4j.pax.web.jsp.JasperInitializer");
                ctx.addServletContainerInitializer((ServletContainerInitializer)loadClass.newInstance(), null);
            }
            catch (ClassNotFoundException e) {
                LOG.error("Unable to load JasperInitializer", (Throwable)e);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Unable to instantiate JasperInitializer", (Throwable)e);
            }
        }
        ((ContainerBase)this.getHost()).setStartChildren(false);
        this.getHost().addChild((Container)ctx);
        for (int i = 0; i < DEFAULT_MIME_MAPPINGS.length; i += 2) {
            ctx.addMimeMapping(DEFAULT_MIME_MAPPINGS[i], DEFAULT_MIME_MAPPINGS[i + 1]);
        }
        return ctx;
    }

    public String generateContextName(String contextName, HttpContext httpContext) {
        String contextId = httpContext instanceof WebContainerContext ? ((WebContainerContext)httpContext).getContextId() : null;
        String name = contextName != null ? (contextId != null ? "[" + contextName + "]-" + contextId : "[" + contextName + "]") : (contextId != null ? "[]-" + contextId : "[]");
        return name;
    }

    private boolean isJspAvailable() {
        try {
            return JspServletWrapper.class != null;
        }
        catch (NoClassDefFoundError ignore) {
            return false;
        }
    }

    private void silence(String ctx) {
        String base = "org.apache.catalina.core.ContainerBase.[default].[";
        base = base + this.getHost().getName();
        base = base + "].[";
        base = base + ctx;
        base = base + "]";
        LOG.warn(base);
    }

    public Host getHost() {
        Engine engine = this.getEngine();
        if (engine.findChildren().length > 0) {
            return (Host)engine.findChildren()[0];
        }
        StandardHost host = new StandardHost();
        ContextSelectionHostValve contextSelect = new ContextSelectionHostValve(host.getPipeline().getBasic(), this.getService().getMapper());
        host.getPipeline().setBasic((Valve)contextSelect);
        host.setName(this.hostname);
        this.getEngine().addChild((Container)host);
        return host;
    }

    private static class FakeCatalina
    extends Catalina {
        private FakeCatalina() {
        }

        protected Digester createStartDigester() {
            Digester digester = super.createStartDigester();
            digester.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            return digester;
        }
    }
}

