/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.logger;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.EventLayout;
import org.apache.karaf.audit.EventLogger;
import org.apache.karaf.audit.util.FastDateFormat;

public class FileEventLogger
implements EventLogger {
    private final Charset encoding;
    private final String policy;
    private final int files;
    private final boolean compress;
    private final Executor executor;
    private final EventLayout layout;
    private boolean daily;
    private long maxSize;
    private long size;
    private Path path;
    private Writer writer;
    private FastDateFormat fastDateFormat;
    private TimeZone timeZone;

    public FileEventLogger(String path, String encoding, String policy, int files, boolean compress, ThreadFactory factory, EventLayout layout, TimeZone timeZone) throws IOException {
        this.fastDateFormat = new FastDateFormat(timeZone, Locale.ENGLISH);
        this.timeZone = timeZone;
        this.path = Paths.get(path, new String[0]);
        this.encoding = Charset.forName(encoding);
        this.policy = policy;
        this.files = files;
        this.compress = compress;
        this.executor = Executors.newSingleThreadExecutor(factory);
        this.layout = layout;
        Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        for (String pol : policy.toLowerCase(Locale.ENGLISH).split("\\s+")) {
            if ("daily".equals(pol)) {
                this.daily = true;
                continue;
            }
            if (pol.matches("size\\([0-9]+(kb|mb|gb)?\\)")) {
                long mult;
                String str = pol.substring(5, pol.length() - 1);
                if (str.endsWith("kb")) {
                    mult = 1024L;
                    str = str.substring(0, str.length() - 2);
                } else if (str.endsWith("mb")) {
                    mult = 0x100000L;
                    str = str.substring(0, str.length() - 2);
                } else if (str.endsWith("gb")) {
                    mult = 0x40000000L;
                    str = str.substring(0, str.length() - 2);
                } else {
                    mult = 1L;
                }
                try {
                    this.maxSize = Long.parseLong(str) * mult;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (this.maxSize > 0L) continue;
                throw new IllegalArgumentException("Unsupported policy: " + pol);
            }
            throw new IllegalArgumentException("Unsupported policy: " + pol);
        }
    }

    @Override
    public void write(Event event) throws IOException {
        long timestamp = event.timestamp();
        if (this.writer == null) {
            this.init();
        } else {
            this.check(timestamp);
        }
        this.layout.format(event, this.writer);
        this.writer.append("\n");
    }

    private void init() throws IOException {
        long timestamp = System.currentTimeMillis();
        if (Files.isRegularFile(this.path, new LinkOption[0])) {
            this.size = Files.size(this.path);
            this.fastDateFormat.sameDay(Files.getLastModifiedTime(this.path, new LinkOption[0]).toMillis());
            if (this.trigger(timestamp)) {
                Path temp = Files.createTempFile(this.path.getParent(), this.path.getFileName().toString(), ".tmp", new FileAttribute[0]);
                Files.move(this.path, temp, new CopyOption[0]);
                this.executor.execute(() -> this.rotate(temp, timestamp));
            }
        }
        this.fastDateFormat.sameDay(timestamp);
        this.writer = new Writer(Files.newBufferedWriter(this.path, this.encoding, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
        this.size = 0L;
    }

    private void check(long timestamp) throws IOException {
        if (this.trigger(timestamp)) {
            if (this.writer != null) {
                this.writer.flush();
                if (Files.size(this.path) == 0L) {
                    return;
                }
                this.writer.close();
            }
            Path temp = Files.createTempFile(this.path.getParent(), this.path.getFileName().toString() + ".", ".tmp", new FileAttribute[0]);
            Files.delete(temp);
            Files.move(this.path, temp, StandardCopyOption.ATOMIC_MOVE);
            this.executor.execute(() -> this.rotate(temp, timestamp));
            this.writer = new Writer(Files.newBufferedWriter(this.path, this.encoding, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
            this.size = 0L;
        }
    }

    private boolean trigger(long timestamp) {
        return this.maxSize > 0L && this.size > this.maxSize || this.daily && !this.fastDateFormat.sameDay(timestamp);
    }

    private void rotate(Path path, long timestamp) {
        try {
            String[] fix = this.getFileNameFix();
            List paths = Files.list(path.getParent()).filter(p -> !p.equals(this.path)).map(Path::getFileName).map(Path::toString).filter(p -> p.startsWith(fix[0])).filter(p -> !p.endsWith(".tmp")).collect(Collectors.toList());
            String date = new FastDateFormat(this.timeZone, Locale.ENGLISH).getDate(timestamp, "yyyy-MM-dd");
            List sameDate = paths.stream().filter(p -> p.matches("\\Q" + fix[0] + "-" + date + "\\E(-[0-9]+)?\\Q" + fix[1] + "\\E")).collect(Collectors.toList());
            String name = fix[0] + "-" + date + fix[1];
            int idx = 0;
            while (sameDate.contains(name)) {
                name = fix[0] + "-" + date + "-" + Integer.toString(++idx) + fix[1];
            }
            paths.add(name);
            Path finalPath = path.resolveSibling(name);
            if (this.compress) {
                try (OutputStream out = Files.newOutputStream(finalPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                     GZIPOutputStream zip = new GZIPOutputStream(out);){
                    Files.copy(path, zip);
                }
                Files.delete(path);
            } else {
                Files.move(path, finalPath, new CopyOption[0]);
            }
            if (this.files > 0 && paths.size() > this.files) {
                Collections.sort(paths);
                paths.subList(paths.size() - this.files, paths.size()).clear();
                for (String p2 : paths) {
                    Files.delete(path.resolveSibling(p2));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String[] getFileNameFix() {
        String str = this.path.getFileName().toString();
        String sfx = this.compress ? ".gz" : "";
        int idx = str.lastIndexOf(46);
        if (idx > 0) {
            return new String[]{str.substring(0, idx), str.substring(idx) + sfx};
        }
        return new String[]{str, sfx};
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    class Writer
    extends java.io.Writer
    implements Appendable,
    Closeable,
    Flushable {
        private final BufferedWriter writer;

        public Writer(BufferedWriter writer) {
            this.writer = writer;
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void write(int c) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + 1L;
            this.writer.write(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + (long)len;
            this.writer.write(cbuf, off, len);
        }

        @Override
        public void write(String s, int off, int len) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + (long)len;
            this.writer.write(s, off, len);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + (long)cbuf.length;
            this.writer.write(cbuf);
        }

        @Override
        public void write(String str) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + (long)str.length();
            this.writer.write(str);
        }

        @Override
        public java.io.Writer append(CharSequence csq) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + (long)csq.length();
            this.writer.append(csq);
            return this;
        }

        @Override
        public java.io.Writer append(CharSequence csq, int start, int end) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + (long)(end - start);
            this.writer.append(csq, start, end);
            return this;
        }

        @Override
        public java.io.Writer append(char c) throws IOException {
            FileEventLogger.this.size = FileEventLogger.this.size + 1L;
            this.writer.append(c);
            return this;
        }
    }
}

