/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.base.Verify;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchPayloadService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchRpcRoutes;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRoute;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.rpcbench.rpc.routes.RpcRouteKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.RpcbenchmarkService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.StartTestOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rpcbenchmark.rev150702.TestStatusOutputBuilder;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.GlobalBindingRTCClient;
import rpcbenchmark.impl.GlobalBindingRTCServer;
import rpcbenchmark.impl.RTCClient;
import rpcbenchmark.impl.RoutedBindingRTClient;

public class RpcbenchmarkProvider
implements AutoCloseable,
RpcbenchmarkService {
    private static final Logger LOG = LoggerFactory.getLogger(RpcbenchmarkProvider.class);
    private static final int TEST_TIMEOUT = 5;
    private final GlobalBindingRTCServer globalServer;
    private final AtomicReference<TestStatusOutput.ExecStatus> execStatus = new AtomicReference<TestStatusOutput.ExecStatus>(TestStatusOutput.ExecStatus.Idle);
    private final RpcProviderService providerRegistry;
    private final RpcConsumerRegistry consumerRegistry;

    public RpcbenchmarkProvider(RpcProviderService providerRegistry, RpcConsumerRegistry consumerRegistry, GlobalBindingRTCServer globalServer) {
        this.providerRegistry = providerRegistry;
        this.consumerRegistry = consumerRegistry;
        this.globalServer = globalServer;
    }

    public void init() {
        LOG.info("RpcbenchmarkProvider initiated");
    }

    @Override
    public void close() {
        LOG.info("RpcbenchmarkProvider closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RpcResult<StartTestOutput>> startTest(StartTestInput input) {
        RTCClient client;
        LOG.debug("startTest {}", (Object)input);
        ArrayList<ObjectRegistration> rpcRegs = new ArrayList<ObjectRegistration>();
        switch (input.getOperation()) {
            case ROUTEDRTC: {
                ArrayList routeIid = new ArrayList();
                for (int i = 0; i < input.getNumServers().intValue(); ++i) {
                    GlobalBindingRTCServer server = new GlobalBindingRTCServer();
                    KeyedInstanceIdentifier iid = InstanceIdentifier.create(RpcbenchRpcRoutes.class).child(RpcRoute.class, (Identifier)new RpcRouteKey(Integer.toString(i)));
                    routeIid.add((InstanceIdentifier<?>)iid);
                    ObjectRegistration routedReg = this.providerRegistry.registerRpcImplementation(RpcbenchPayloadService.class, (RpcService)server, Set.of(iid));
                    rpcRegs.add(routedReg);
                }
                client = new RoutedBindingRTClient(this.consumerRegistry, input.getPayloadSize().intValue(), routeIid);
                break;
            }
            case GLOBALRTC: {
                client = new GlobalBindingRTCClient(this.consumerRegistry, input.getPayloadSize().intValue());
                break;
            }
            default: {
                LOG.error("Unsupported server/client type {}", (Object)input.getOperation());
                throw new IllegalArgumentException("Unsupported server/client type" + input.getOperation());
            }
        }
        try {
            ExecutorService executor = Executors.newFixedThreadPool(input.getNumClients().intValue());
            Runnable testRun = () -> client.runTest(input.getIterations().intValue());
            LOG.info("Test Started");
            long startTime = System.nanoTime();
            for (int i = 0; i < input.getNumClients().intValue(); ++i) {
                Verify.verifyNotNull(executor.submit(testRun));
            }
            executor.shutdown();
            try {
                executor.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                LOG.error("Out of time: test did not finish within the {} min deadline ", (Object)5);
            }
            long endTime = System.nanoTime();
            LOG.info("Test Done");
            long elapsedTime = endTime - startTime;
            StartTestOutput output = new StartTestOutputBuilder().setRate(Uint32.ZERO).setGlobalRtcClientError(Uint32.valueOf((long)client.getRpcError())).setGlobalRtcClientOk(Uint32.valueOf((long)client.getRpcOk())).setExecTime(Uint32.valueOf((long)TimeUnit.NANOSECONDS.toMillis(elapsedTime))).setRate(Uint32.valueOf((long)((client.getRpcOk() + client.getRpcError()) * 1000000000L / elapsedTime))).build();
            FluentFuture fluentFuture = RpcResultBuilder.success((Object)output).buildFuture();
            return fluentFuture;
        }
        finally {
            rpcRegs.forEach(Registration::close);
        }
    }

    public ListenableFuture<RpcResult<TestStatusOutput>> testStatus(TestStatusInput input) {
        LOG.info("testStatus");
        TestStatusOutput output = new TestStatusOutputBuilder().setGlobalServerCnt(Uint32.valueOf((int)this.globalServer.getNumRpcs())).setExecStatus(this.execStatus.get()).build();
        return RpcResultBuilder.success((Object)output).buildFuture();
    }
}

