/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.parser;

import com.google.common.annotations.Beta;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2ExtensionsMapping;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccess;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccessEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.MaxAccessStatement;
import org.opendaylight.yangtools.rfc6643.parser.MaxAccessEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.MaxAccessStatementImpl;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class MaxAccessStatementSupport
extends AbstractStatementSupport<MaxAccess, MaxAccessStatement, MaxAccessEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)IetfYangSmiv2ExtensionsMapping.MAX_ACCESS).build();
    private static final MaxAccessStatementSupport INSTANCE = new MaxAccessStatementSupport();

    private MaxAccessStatementSupport() {
        super((StatementDefinition)IetfYangSmiv2ExtensionsMapping.MAX_ACCESS);
    }

    public static MaxAccessStatementSupport getInstance() {
        return INSTANCE;
    }

    public MaxAccess parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        MaxAccess val = MaxAccess.forStringLiteral((String)value);
        if (val == null) {
            throw new SourceException(ctx.getStatementSourceReference(), "Invalid max-access value '%s'", new Object[]{value});
        }
        return val;
    }

    public String internArgument(String rawArgument) {
        MaxAccess val = MaxAccess.forStringLiteral((String)rawArgument);
        return val == null ? rawArgument : val.stringLiteral();
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    public MaxAccessStatement createDeclared(StmtContext<MaxAccess, MaxAccessStatement, ?> ctx) {
        return new MaxAccessStatementImpl(ctx);
    }

    public MaxAccessEffectiveStatement createEffective(StmtContext<MaxAccess, MaxAccessStatement, MaxAccessEffectiveStatement> ctx) {
        return new MaxAccessEffectiveStatementImpl(ctx);
    }
}

