/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;

@Beta
public abstract class ArgumentDefinition
implements Immutable {
    private final @NonNull QName argumentName;

    ArgumentDefinition(QName argumentName) {
        this.argumentName = Objects.requireNonNull(argumentName);
    }

    public static @NonNull ArgumentDefinition of(QName argumentName, boolean yinElement) {
        return yinElement ? new YinElement(argumentName) : new YinAttribute(argumentName);
    }

    public static @NonNull Optional<ArgumentDefinition> ofNullable(@Nullable QName argumentName, boolean yinElement) {
        return argumentName == null ? Optional.empty() : Optional.of(ArgumentDefinition.of(argumentName, yinElement));
    }

    public final @NonNull QName getArgumentName() {
        return this.argumentName;
    }

    public abstract boolean isYinElement();

    public final int hashCode() {
        return Boolean.hashCode(this.isYinElement()) * 31 + this.argumentName.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArgumentDefinition)) {
            return false;
        }
        ArgumentDefinition other = (ArgumentDefinition)obj;
        return this.isYinElement() == other.isYinElement() && this.argumentName.equals((Object)other.argumentName);
    }

    public final String toString() {
        return MoreObjects.toStringHelper(ArgumentDefinition.class).add("argumentName", (Object)this.argumentName).add("yinElement", this.isYinElement()).toString();
    }

    private static final class YinElement
    extends ArgumentDefinition {
        YinElement(QName argumentName) {
            super(argumentName);
        }

        @Override
        public boolean isYinElement() {
            return true;
        }
    }

    private static final class YinAttribute
    extends ArgumentDefinition {
        YinAttribute(QName argumentName) {
            super(argumentName);
        }

        @Override
        public boolean isYinElement() {
            return false;
        }
    }
}

