/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.Verify;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.BodyDeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LinkageDeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MetaDeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleHeaderGroup;
import org.opendaylight.yangtools.yang.model.api.stmt.NamespaceStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RevisionAwareDeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionStatement;

public interface ModuleStatement
extends MetaDeclaredStatement<String>,
ModuleHeaderGroup,
LinkageDeclaredStatement,
RevisionAwareDeclaredStatement,
BodyDeclaredStatement {
    @Override
    default public StatementDefinition statementDefinition() {
        return YangStmtMapping.MODULE;
    }

    default public @NonNull String getName() {
        return (String)Verify.verifyNotNull((Object)this.rawArgument());
    }

    @Override
    default public YangVersionStatement getYangVersion() {
        Optional<YangVersionStatement> opt = this.findFirstDeclaredSubstatement(YangVersionStatement.class);
        return opt.isPresent() ? opt.get() : null;
    }

    @Override
    default public NamespaceStatement getNamespace() {
        return this.findFirstDeclaredSubstatement(NamespaceStatement.class).get();
    }

    @Override
    default public PrefixStatement getPrefix() {
        return this.findFirstDeclaredSubstatement(PrefixStatement.class).get();
    }
}

