/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public abstract class SchemaNodeIdentifier
implements Immutable {
    private static final AtomicReferenceFieldUpdater<SchemaNodeIdentifier, SchemaPath> SCHEMAPATH_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SchemaNodeIdentifier.class, SchemaPath.class, "schemaPath");
    private volatile SchemaPath schemaPath;
    private volatile int hash;

    SchemaNodeIdentifier() {
    }

    public abstract @NonNull List<QName> getNodeIdentifiers();

    public final @NonNull SchemaPath asSchemaPath() {
        SchemaPath ret = this.schemaPath;
        return ret != null ? ret : this.loadSchemaPath();
    }

    public final int hashCode() {
        int local = this.hash;
        return local != 0 ? local : (this.hash = this.pathObject().hashCode());
    }

    public final boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.pathObject().equals(((SchemaNodeIdentifier)obj).pathObject());
    }

    public final String toString() {
        return MoreObjects.toStringHelper((String)this.className()).add("qnames", this.toStringQNames()).toString();
    }

    abstract @NonNull SchemaPath implicitSchemaPathParent();

    abstract @NonNull Object pathObject();

    abstract @NonNull String className();

    private @NonNull SchemaPath loadSchemaPath() {
        SchemaPath newPath = this.implicitSchemaPathParent().createChild(this.getNodeIdentifiers());
        return SCHEMAPATH_UPDATER.compareAndSet(this, null, newPath) ? newPath : this.schemaPath;
    }

    private List<?> toStringQNames() {
        List<QName> ids = this.getNodeIdentifiers();
        return ids.size() < 2 ? ids : SchemaNodeIdentifier.simplifyQNames(ids);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static ImmutableList<QName> checkQNames(Collection<QName> qnames) {
        ImmutableList ret = ImmutableList.copyOf(qnames);
        Preconditions.checkArgument((!ret.isEmpty() ? 1 : 0) != 0, (Object)"SchemaNodeIdentifier has to have at least one node identifier");
        return ret;
    }

    private static List<?> simplifyQNames(List<QName> qnames) {
        ArrayList<QName> ret = new ArrayList<QName>(qnames.size());
        QNameModule prev = null;
        for (QName qname : qnames) {
            QNameModule module = qname.getModule();
            ret.add((QName)(module.equals(prev) ? qname.getLocalName() : qname));
            prev = module;
        }
        return ret;
    }

    private static final class DescandantMultiple
    extends Descendant {
        private final @NonNull ImmutableList<QName> qnames;

        DescandantMultiple(ImmutableList<QName> qnames) {
            this.qnames = Objects.requireNonNull(qnames);
        }

        public ImmutableList<QName> getNodeIdentifiers() {
            return this.qnames;
        }

        @Override
        Object pathObject() {
            return this.qnames;
        }
    }

    private static final class DescendantSingle
    extends Descendant {
        private final @NonNull QName qname;

        DescendantSingle(QName qname) {
            this.qname = Objects.requireNonNull(qname);
        }

        public ImmutableList<QName> getNodeIdentifiers() {
            return ImmutableList.of((Object)this.qname);
        }

        @Override
        Object pathObject() {
            return this.qname;
        }
    }

    private static final class AbsoluteMultiple
    extends Absolute {
        private final @NonNull ImmutableList<QName> qnames;

        AbsoluteMultiple(ImmutableList<QName> qnames) {
            this.qnames = Objects.requireNonNull(qnames);
        }

        public ImmutableList<QName> getNodeIdentifiers() {
            return this.qnames;
        }

        @Override
        public @NonNull QName firstNodeIdentifier() {
            return (QName)this.qnames.get(0);
        }

        @Override
        public @NonNull QName lastNodeIdentifier() {
            return (QName)this.qnames.get(this.qnames.size() - 1);
        }

        @Override
        Object pathObject() {
            return this.qnames;
        }
    }

    private static final class AbsoluteSingle
    extends Absolute {
        private final @NonNull QName qname;

        AbsoluteSingle(QName qname) {
            this.qname = Objects.requireNonNull(qname);
        }

        public ImmutableList<QName> getNodeIdentifiers() {
            return ImmutableList.of((Object)this.qname);
        }

        @Override
        public QName firstNodeIdentifier() {
            return this.qname;
        }

        @Override
        public QName lastNodeIdentifier() {
            return this.qname;
        }

        @Override
        Object pathObject() {
            return this.qname;
        }
    }

    public static abstract class Descendant
    extends SchemaNodeIdentifier {
        Descendant() {
        }

        public static @NonNull Descendant of(QName nodeIdentifier) {
            return new DescendantSingle(nodeIdentifier);
        }

        public static @NonNull Descendant of(QName ... nodeIdentifiers) {
            return Descendant.of(Arrays.asList(nodeIdentifiers));
        }

        public static @NonNull Descendant of(Collection<QName> nodeIdentifiers) {
            ImmutableList<QName> qnames = SchemaNodeIdentifier.checkQNames(nodeIdentifiers);
            return qnames.size() == 1 ? Descendant.of((QName)qnames.get(0)) : new DescandantMultiple(qnames);
        }

        @Override
        final SchemaPath implicitSchemaPathParent() {
            return SchemaPath.SAME;
        }

        @Override
        final String className() {
            return "Descendant";
        }
    }

    public static abstract class Absolute
    extends SchemaNodeIdentifier {
        private static final Interner<Absolute> INTERNER = Interners.newWeakInterner();

        Absolute() {
        }

        public static @NonNull Absolute of(QName nodeIdentifier) {
            return new AbsoluteSingle(nodeIdentifier);
        }

        public static @NonNull Absolute of(QName ... nodeIdentifiers) {
            return Absolute.of(Arrays.asList(nodeIdentifiers));
        }

        public static @NonNull Absolute of(Collection<QName> nodeIdentifiers) {
            ImmutableList<QName> qnames = SchemaNodeIdentifier.checkQNames(nodeIdentifiers);
            return qnames.size() == 1 ? Absolute.of((QName)qnames.get(0)) : new AbsoluteMultiple(qnames);
        }

        public final @NonNull Absolute intern() {
            return (Absolute)INTERNER.intern((Object)this);
        }

        public abstract @NonNull QName firstNodeIdentifier();

        public abstract @NonNull QName lastNodeIdentifier();

        @Override
        final SchemaPath implicitSchemaPathParent() {
            return SchemaPath.ROOT;
        }

        @Override
        final String className() {
            return "Absolute";
        }
    }
}

