/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.type;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;

final class TypeDefinitions {
    private TypeDefinitions() {
    }

    static int basicHashCode(@NonNull TypeDefinition<?> type) {
        return Objects.hash(type.getPath(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue().orElse(null));
    }

    static int hashCode(@NonNull RangeRestrictedTypeDefinition<?, ?> type) {
        return Objects.hash(type.getPath(), type.getUnknownSchemaNodes(), type.getBaseType(), type.getUnits().orElse(null), type.getDefaultValue().orElse(null), type.getRangeConstraint().orElse(null));
    }

    static <T extends RangeRestrictedTypeDefinition<T, ?>> boolean equals(@NonNull Class<T> clazz, @NonNull T type, @Nullable Object obj) {
        if (type == obj) {
            return true;
        }
        @Nullable RangeRestrictedTypeDefinition other = (RangeRestrictedTypeDefinition)TypeDefinitions.castIfEquals(clazz, type, obj);
        return other != null && type.getRangeConstraint().equals(other.getRangeConstraint());
    }

    static @NonNull String toString(@NonNull RangeRestrictedTypeDefinition<?, ?> type) {
        return TypeDefinitions.toStringHelper(type).toString();
    }

    static <T extends TypeDefinition<T>> @Nullable T castIfEquals(@NonNull Class<T> clazz, @NonNull T type, @Nullable Object obj) {
        if (!clazz.isInstance(obj)) {
            return null;
        }
        @NonNull TypeDefinition other = (TypeDefinition)clazz.cast(obj);
        return (T)(Objects.equals(type.getPath(), other.getPath()) && Objects.equals(type.getBaseType(), other.getBaseType()) && Objects.equals(type.getDefaultValue(), other.getDefaultValue()) && Objects.equals(type.getUnknownSchemaNodes(), other.getUnknownSchemaNodes()) && Objects.equals(type.getUnits(), other.getUnits()) ? other : null);
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper(@NonNull TypeDefinition<?> type) {
        return MoreObjects.toStringHelper(type).omitNullValues().add("path", (Object)type.getPath()).add("baseType", type.getBaseType()).add("default", type.getDefaultValue().orElse(null)).add("description", type.getDescription().orElse(null)).add("reference", type.getReference().orElse(null)).add("status", (Object)type.getStatus()).add("units", type.getUnits().orElse(null));
    }

    static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper(@NonNull RangeRestrictedTypeDefinition<?, ?> type) {
        return TypeDefinitions.toStringHelper(type).add("range", type.getRangeConstraint().orElse(null));
    }
}

