/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.primitives.UnsignedLong;
import org.opendaylight.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.binding.runtime.spi.ForwardingBindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.osgi.OSGiBindingRuntimeContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(service={BindingRuntimeContext.class}, immediate=true)
public final class GlobalBindingRuntimeContext
extends ForwardingBindingRuntimeContext {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingRuntimeContext.class);
    @Reference
    OSGiBindingRuntimeContext osgi = null;
    private BindingRuntimeContext delegate;
    private UnsignedLong generation;

    protected BindingRuntimeContext delegate() {
        return (BindingRuntimeContext)Verify.verifyNotNull((Object)this.delegate);
    }

    @Activate
    void activate() {
        this.generation = this.osgi.getGeneration();
        this.delegate = (BindingRuntimeContext)this.osgi.getService();
        LOG.info("Global BindingRuntimeContext generation {} activated", (Object)this.generation);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("Global BindingRuntimeContext generation {} deactivated", (Object)this.generation);
    }
}

