/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;

@Beta
public class DataTreeConfiguration
implements Immutable {
    public static final DataTreeConfiguration DEFAULT_CONFIGURATION = new Builder(TreeType.CONFIGURATION).setMandatoryNodesValidation(true).build();
    public static final DataTreeConfiguration DEFAULT_OPERATIONAL = new Builder(TreeType.OPERATIONAL).setMandatoryNodesValidation(true).build();
    private final @NonNull TreeType treeType;
    private final @NonNull YangInstanceIdentifier rootPath;
    private final boolean uniqueIndexes;
    private final boolean mandatoryNodesValidation;

    DataTreeConfiguration(TreeType treeType, YangInstanceIdentifier rootPath, boolean uniqueIndexes, boolean mandatoryNodesValidation) {
        this.treeType = Objects.requireNonNull(treeType);
        this.rootPath = Objects.requireNonNull(rootPath);
        this.uniqueIndexes = uniqueIndexes;
        this.mandatoryNodesValidation = mandatoryNodesValidation;
    }

    public @NonNull YangInstanceIdentifier getRootPath() {
        return this.rootPath;
    }

    public @NonNull TreeType getTreeType() {
        return this.treeType;
    }

    public boolean isUniqueIndexEnabled() {
        return this.uniqueIndexes;
    }

    public boolean isMandatoryNodesValidationEnabled() {
        return this.mandatoryNodesValidation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.treeType).add("root", (Object)this.rootPath).add("mandatory", this.mandatoryNodesValidation).add("unique", this.uniqueIndexes).toString();
    }

    public static DataTreeConfiguration getDefault(TreeType treeType) {
        switch (Objects.requireNonNull(treeType)) {
            case CONFIGURATION: {
                return DEFAULT_CONFIGURATION;
            }
            case OPERATIONAL: {
                return DEFAULT_OPERATIONAL;
            }
        }
        return new DataTreeConfiguration(treeType, YangInstanceIdentifier.empty(), false, true);
    }

    public static Builder builder(TreeType treeType) {
        return new Builder(treeType);
    }

    public Builder copyBuilder() {
        return new Builder(this.treeType).setMandatoryNodesValidation(this.isMandatoryNodesValidationEnabled()).setUniqueIndexes(this.isUniqueIndexEnabled()).setRootPath(this.getRootPath());
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<DataTreeConfiguration> {
        private final TreeType treeType;
        private YangInstanceIdentifier rootPath;
        private boolean uniqueIndexes;
        private boolean mandatoryNodesValidation;

        public Builder(TreeType treeType) {
            this.treeType = Objects.requireNonNull(treeType);
            this.rootPath = YangInstanceIdentifier.empty();
        }

        public Builder setUniqueIndexes(boolean uniqueIndexes) {
            this.uniqueIndexes = uniqueIndexes;
            return this;
        }

        public Builder setMandatoryNodesValidation(boolean mandatoryNodesValidation) {
            this.mandatoryNodesValidation = mandatoryNodesValidation;
            return this;
        }

        public Builder setRootPath(YangInstanceIdentifier rootPath) {
            this.rootPath = rootPath.toOptimized();
            return this;
        }

        public DataTreeConfiguration build() {
            return new DataTreeConfiguration(this.treeType, this.rootPath, this.uniqueIndexes, this.mandatoryNodesValidation);
        }
    }
}

