/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.AbstractBaseType;
import org.opendaylight.yangtools.yang.model.util.type.ResolvedRangeConstraint;

abstract class AbstractRangeRestrictedBaseType<T extends RangeRestrictedTypeDefinition<T, N>, N extends Number>
extends AbstractBaseType<T>
implements RangeRestrictedTypeDefinition<T, N> {
    private static final ConstraintMetaDefinition BUILTIN_CONSTRAINT = new ConstraintMetaDefinition(){

        public Optional<String> getReference() {
            return Optional.empty();
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getErrorMessage() {
            return Optional.empty();
        }

        public Optional<String> getErrorAppTag() {
            return Optional.empty();
        }
    };
    private final RangeConstraint<N> rangeConstraint;

    AbstractRangeRestrictedBaseType(QName qname, N minValue, N maxValue) {
        super(qname);
        this.rangeConstraint = new ResolvedRangeConstraint<N>(BUILTIN_CONSTRAINT, ImmutableRangeSet.of((Range)Range.closed(minValue, maxValue)));
    }

    AbstractRangeRestrictedBaseType(SchemaPath path, Collection<? extends UnknownSchemaNode> unknownSchemaNodes, RangeConstraint<N> rangeConstraint) {
        super(path, unknownSchemaNodes);
        this.rangeConstraint = Objects.requireNonNull(rangeConstraint);
    }

    public final Optional<RangeConstraint<N>> getRangeConstraint() {
        return Optional.of(this.rangeConstraint);
    }
}

