/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.dispatch.OnComplete;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

abstract class AbstractRemoteFuture<T, E extends Exception>
extends AbstractFuture<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRemoteFuture.class);
    private final @NonNull SchemaPath type;

    AbstractRemoteFuture(@NonNull SchemaPath type, Future<Object> requestFuture) {
        this.type = Objects.requireNonNull(type);
        requestFuture.onComplete((Function1)new FutureUpdater(), ExecutionContext.Implicits$.MODULE$.global());
    }

    public final T get() throws InterruptedException, ExecutionException {
        try {
            return (T)super.get();
        }
        catch (ExecutionException e) {
            throw this.mapException(e);
        }
    }

    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)super.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw this.mapException(e);
        }
    }

    protected final boolean set(T value) {
        boolean ret = super.set(value);
        if (ret) {
            LOG.debug("Future {} for action {} successfully completed", (Object)this, (Object)this.type);
        }
        return ret;
    }

    final void failNow(Throwable error) {
        LOG.debug("Failing future {} for operation {}", new Object[]{this, this.type, error});
        this.setException(error);
    }

    abstract @Nullable T processReply(Object var1);

    abstract @NonNull Class<E> exceptionClass();

    abstract @NonNull E wrapCause(Throwable var1);

    private ExecutionException mapException(ExecutionException ex) {
        Throwable cause = ex.getCause();
        return this.exceptionClass().isInstance(cause) ? ex : new ExecutionException(ex.getMessage(), (Throwable)this.wrapCause(cause));
    }

    private final class FutureUpdater
    extends OnComplete<Object> {
        private FutureUpdater() {
        }

        public void onComplete(Throwable error, Object reply) {
            if (error == null) {
                Object result = AbstractRemoteFuture.this.processReply(reply);
                if (result != null) {
                    LOG.debug("Received response for operation {}: result is {}", (Object)AbstractRemoteFuture.this.type, result);
                    AbstractRemoteFuture.this.set(result);
                } else {
                    AbstractRemoteFuture.this.failNow(new IllegalStateException("Incorrect reply type " + reply + " from Akka"));
                }
            } else {
                AbstractRemoteFuture.this.failNow(error);
            }
        }
    }
}

