/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.util.Objects;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.messages.AbstractExecute;
import scala.concurrent.Future;

abstract class AbstractRemoteImplementation<T extends AbstractExecute<?>> {
    static final long COST = 2L;
    private final ActorRef remoteInvoker;
    private final Timeout askDuration;

    AbstractRemoteImplementation(ActorRef remoteInvoker, RemoteOpsProviderConfig config) {
        this.remoteInvoker = Objects.requireNonNull(remoteInvoker);
        this.askDuration = config.getAskDuration();
    }

    final Future<Object> ask(T message) {
        return Patterns.ask((ActorRef)this.remoteInvoker, Objects.requireNonNull(message), (Timeout)this.askDuration);
    }
}

