/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.remote.rpc.RpcErrorsException;
import org.opendaylight.controller.remote.rpc.messages.ActionResponse;
import org.opendaylight.controller.remote.rpc.messages.ExecuteAction;
import org.opendaylight.controller.remote.rpc.messages.ExecuteRpc;
import org.opendaylight.controller.remote.rpc.messages.RpcResponse;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class OpsInvoker
extends AbstractUntypedActor {
    private final DOMRpcService rpcService;
    private final DOMActionService actionService;

    private OpsInvoker(DOMRpcService rpcService, DOMActionService actionService) {
        this.rpcService = Objects.requireNonNull(rpcService);
        this.actionService = Objects.requireNonNull(actionService);
    }

    public static Props props(DOMRpcService rpcService, DOMActionService actionService) {
        return Props.create(OpsInvoker.class, (Object[])new Object[]{Objects.requireNonNull(rpcService, "DOMRpcService can not be null"), Objects.requireNonNull(actionService, "DOMActionService can not be null")});
    }

    protected void handleReceive(Object message) {
        if (message instanceof ExecuteRpc) {
            this.LOG.debug("Handling ExecuteOps Message");
            this.execute((ExecuteRpc)message);
        } else if (message instanceof ExecuteAction) {
            this.execute((ExecuteAction)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void execute(ExecuteRpc msg) {
        ListenableFuture future;
        this.LOG.debug("Executing RPC {}", (Object)msg.getType());
        ActorRef sender = this.getSender();
        try {
            future = this.rpcService.invokeRpc(msg.getType(), msg.getInput());
        }
        catch (RuntimeException e) {
            this.LOG.debug("Failed to invoke RPC {}", (Object)msg.getType(), (Object)e);
            sender.tell((Object)new Status.Failure((Throwable)e), this.self());
            return;
        }
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new AbstractCallback<DOMRpcResult>(this.getSender(), msg.getType()){

            @Override
            Object nullResponse(SchemaPath type) {
                OpsInvoker.this.LOG.warn("Execution of {} resulted in null result", (Object)type);
                return new RpcResponse(null);
            }

            @Override
            Object response(SchemaPath type, DOMRpcResult result) {
                Collection errors = result.getErrors();
                return errors.isEmpty() ? new RpcResponse(result.getResult()) : new Status.Failure((Throwable)((Object)new RpcErrorsException(String.format("Execution of rpc %s failed", type), errors)));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void execute(ExecuteAction msg) {
        ListenableFuture future;
        this.LOG.debug("Executing Action {}", (Object)msg.getType());
        ActorRef sender = this.getSender();
        try {
            future = this.actionService.invokeAction(msg.getType(), msg.getPath(), (ContainerNode)msg.getInput());
        }
        catch (RuntimeException e) {
            this.LOG.debug("Failed to invoke action {}", (Object)msg.getType(), (Object)e);
            sender.tell((Object)new Status.Failure((Throwable)e), this.self());
            return;
        }
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new AbstractCallback<DOMActionResult>(this.getSender(), msg.getType()){

            @Override
            Object nullResponse(SchemaPath type) {
                throw new IllegalStateException("Null invocation result of action " + type);
            }

            @Override
            Object response(SchemaPath type, DOMActionResult result) {
                Collection errors = result.getErrors();
                return errors.isEmpty() ? new ActionResponse(result.getOutput(), result.getErrors()) : new Status.Failure((Throwable)((Object)new RpcErrorsException(String.format("Execution of action %s failed", type), errors)));
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private abstract class AbstractCallback<T>
    implements FutureCallback<T> {
        private final ActorRef replyTo;
        private final SchemaPath type;

        AbstractCallback(ActorRef replyTo, SchemaPath type) {
            this.replyTo = Objects.requireNonNull(replyTo);
            this.type = Objects.requireNonNull(type);
        }

        public final void onSuccess(T result) {
            Object response = result == null ? this.nullResponse(this.type) : this.response(this.type, result);
            OpsInvoker.this.LOG.debug("Sending response for execution of {} : {}", (Object)this.type, response);
            this.replyTo.tell(response, OpsInvoker.this.self());
        }

        public final void onFailure(Throwable failure) {
            OpsInvoker.this.LOG.debug("Failed to execute operation {}", (Object)this.type, (Object)failure);
            OpsInvoker.this.LOG.error("Failed to execute operation {} due to {}. More details are available on DEBUG level.", (Object)this.type, (Object)Throwables.getRootCause((Throwable)failure).getMessage());
            this.replyTo.tell((Object)new Status.Failure(failure), OpsInvoker.this.self());
        }

        abstract @NonNull Object nullResponse(@NonNull SchemaPath var1);

        abstract @NonNull Object response(@NonNull SchemaPath var1, @NonNull T var2);
    }
}

