/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc.registry;

import akka.actor.ActorRef;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.remote.rpc.registry.gossip.BucketData;

public abstract class AbstractRoutingTable<T extends AbstractRoutingTable<T, I>, I>
implements BucketData<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull ActorRef invoker;
    private final @NonNull ImmutableSet<I> items;

    AbstractRoutingTable(ActorRef invoker, Collection<I> items) {
        this.invoker = Objects.requireNonNull(invoker);
        this.items = ImmutableSet.copyOf(items);
    }

    @Override
    public final Optional<ActorRef> getWatchActor() {
        return Optional.of(this.invoker);
    }

    public final @NonNull ImmutableSet<I> getItems() {
        return this.items;
    }

    final @NonNull ActorRef getInvoker() {
        return this.invoker;
    }

    @VisibleForTesting
    public final boolean contains(I routeId) {
        return this.items.contains(routeId);
    }

    @VisibleForTesting
    public final int size() {
        return this.items.size();
    }

    abstract Object writeReplace();

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("invoker", (Object)this.invoker).add("items", this.items).toString();
    }
}

