/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMActionAvailabilityExtension;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTable;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTableEntry;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

@Beta
final class DOMActionRoutingTable
extends AbstractDOMRoutingTable<DOMActionInstance, DOMDataTreeIdentifier, DOMActionImplementation, DOMActionAvailabilityExtension.AvailabilityListener, DOMActionRoutingTableEntry> {
    static final DOMActionRoutingTable EMPTY = new DOMActionRoutingTable((Map<SchemaPath, DOMActionRoutingTableEntry>)ImmutableMap.of(), null);

    private DOMActionRoutingTable(Map<SchemaPath, DOMActionRoutingTableEntry> actions, EffectiveModelContext schemaContext) {
        super(actions, schemaContext);
    }

    protected DOMActionRoutingTable newInstance(Map<SchemaPath, DOMActionRoutingTableEntry> operations, EffectiveModelContext schemaContext) {
        return new DOMActionRoutingTable(operations, schemaContext);
    }

    @Override
    protected ListMultimap<SchemaPath, DOMDataTreeIdentifier> decomposeIdentifiers(Set<DOMActionInstance> instances) {
        LinkedListMultimap ret = LinkedListMultimap.create();
        for (DOMActionInstance instance : instances) {
            instance.getDataTrees().forEach(arg_0 -> DOMActionRoutingTable.lambda$decomposeIdentifiers$0((ListMultimap)ret, instance, arg_0));
        }
        return ret;
    }

    @Override
    protected DOMActionRoutingTableEntry createOperationEntry(EffectiveModelContext context, SchemaPath type, Map<DOMDataTreeIdentifier, List<DOMActionImplementation>> implementations) {
        ActionDefinition actionDef = DOMActionRoutingTable.findActionDefinition((SchemaContext)context, type);
        if (actionDef == null) {
            return null;
        }
        return new DOMActionRoutingTableEntry(type, implementations);
    }

    private static ActionDefinition findActionDefinition(SchemaContext context, SchemaPath path) {
        SchemaNode node = SchemaContextUtil.findDataSchemaNode((SchemaContext)context, (SchemaPath)path.getParent());
        if (node instanceof ActionNodeContainer) {
            return ((ActionNodeContainer)node).findAction(path.getLastComponent()).orElse(null);
        }
        return null;
    }

    private static /* synthetic */ void lambda$decomposeIdentifiers$0(ListMultimap ret, DOMActionInstance instance, DOMDataTreeIdentifier id) {
        ret.put((Object)instance.getType(), (Object)id);
    }
}

