/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.lmax.disruptor.EventFactory;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMNotificationRouterEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouterEvent.class);
    static final EventFactory<DOMNotificationRouterEvent> FACTORY = DOMNotificationRouterEvent::new;
    private Collection<AbstractListenerRegistration<? extends DOMNotificationListener>> subscribers;
    private DOMNotification notification;
    private SettableFuture<Void> future;

    private DOMNotificationRouterEvent() {
    }

    ListenableFuture<Void> initialize(DOMNotification notification, Collection<AbstractListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        this.notification = Objects.requireNonNull(notification);
        this.subscribers = Objects.requireNonNull(subscribers);
        this.future = SettableFuture.create();
        return this.future;
    }

    void deliverNotification() {
        for (AbstractListenerRegistration<? extends DOMNotificationListener> reg : this.subscribers) {
            if (!reg.notClosed()) continue;
            DOMNotificationListener listener = (DOMNotificationListener)reg.getInstance();
            try {
                listener.onNotification(this.notification);
            }
            catch (Exception e) {
                LOG.warn("Listener {} failed during notification delivery", (Object)listener, (Object)e);
            }
        }
    }

    void setFuture() {
        this.future.set(null);
    }
}

