/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTable;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.GlobalDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.RoutedDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.UnknownDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.spi.RpcRoutingStrategy;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class DOMRpcRoutingTable
extends AbstractDOMRoutingTable<DOMRpcIdentifier, YangInstanceIdentifier, DOMRpcImplementation, DOMRpcAvailabilityListener, AbstractDOMRpcRoutingTableEntry> {
    static final DOMRpcRoutingTable EMPTY = new DOMRpcRoutingTable((Map<SchemaPath, AbstractDOMRpcRoutingTableEntry>)ImmutableMap.of(), null);

    private DOMRpcRoutingTable(Map<SchemaPath, AbstractDOMRpcRoutingTableEntry> rpcs, EffectiveModelContext schemaContext) {
        super(rpcs, schemaContext);
    }

    boolean contains(DOMRpcIdentifier input) {
        AbstractDOMRpcRoutingTableEntry contexts = (AbstractDOMRpcRoutingTableEntry)this.getEntry(input.getType());
        return contexts != null && contexts.containsContext(input.getContextReference());
    }

    protected DOMRpcRoutingTable newInstance(Map<SchemaPath, AbstractDOMRpcRoutingTableEntry> operations, EffectiveModelContext schemaContext) {
        return new DOMRpcRoutingTable(operations, schemaContext);
    }

    @Override
    protected ListMultimap<SchemaPath, YangInstanceIdentifier> decomposeIdentifiers(Set<DOMRpcIdentifier> rpcs) {
        LinkedListMultimap ret = LinkedListMultimap.create();
        for (DOMRpcIdentifier i : rpcs) {
            ret.put((Object)i.getType(), (Object)i.getContextReference());
        }
        return ret;
    }

    @Override
    AbstractDOMRpcRoutingTableEntry createOperationEntry(EffectiveModelContext context, SchemaPath key, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> implementations) {
        RpcDefinition rpcDef = DOMRpcRoutingTable.findRpcDefinition((SchemaContext)context, key);
        if (rpcDef == null) {
            return new UnknownDOMRpcRoutingTableEntry(key, implementations);
        }
        RpcRoutingStrategy strategy = RpcRoutingStrategy.from((RpcDefinition)rpcDef);
        if (strategy.isContextBasedRouted()) {
            return new RoutedDOMRpcRoutingTableEntry(rpcDef, YangInstanceIdentifier.of((QName)strategy.getLeaf()), implementations);
        }
        return new GlobalDOMRpcRoutingTableEntry(rpcDef, implementations);
    }

    private static RpcDefinition findRpcDefinition(SchemaContext context, SchemaPath schemaPath) {
        QName qname;
        Module module;
        if (context != null && (module = (Module)context.findModule((qname = (QName)schemaPath.getPathFromRoot().iterator().next()).getModule()).orElse(null)) != null && module.getRpcs() != null) {
            for (RpcDefinition rpc : module.getRpcs()) {
                if (!qname.equals((Object)rpc.getQName())) continue;
                return rpc;
            }
        }
        return null;
    }
}

