/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.broker.ProducerLayout;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataTreeProducer;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardedDOMDataTreeWriteTransaction
implements DOMDataTreeCursorAwareTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMDataTreeWriteTransaction.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Map<DOMDataTreeIdentifier, DOMDataTreeShardWriteTransaction> transactions;
    private final ShardedDOMDataTreeProducer producer;
    private final ProducerLayout layout;
    private final String identifier;
    private final SettableFuture<CommitInfo> future = SettableFuture.create();
    private @GuardedBy(value={"this"}) boolean closed = false;
    private @GuardedBy(value={"this"}) DOMDataTreeWriteCursor openCursor;

    ShardedDOMDataTreeWriteTransaction(ShardedDOMDataTreeProducer producer, Map<DOMDataTreeIdentifier, DOMDataTreeShardWriteTransaction> transactions, ProducerLayout layout) {
        this.producer = Objects.requireNonNull(producer);
        this.transactions = ImmutableMap.copyOf(transactions);
        this.layout = Objects.requireNonNull(layout);
        this.identifier = "SHARDED-DOM-" + COUNTER.getAndIncrement();
        LOG.debug("Created new transaction {}", (Object)this.identifier);
    }

    private DOMDataTreeShardWriteTransaction lookup(DOMDataTreeIdentifier prefix) {
        DOMDataTreeShardWriteTransaction fast = this.transactions.get(prefix);
        if (fast != null) {
            return fast;
        }
        LOG.debug("Prefix {} not found in available subtrees {}, fallback to slow path", (Object)prefix, this.transactions.keySet());
        for (Map.Entry<DOMDataTreeIdentifier, DOMDataTreeShardWriteTransaction> e : this.transactions.entrySet()) {
            if (!e.getKey().contains(prefix)) continue;
            return e.getValue();
        }
        return null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public synchronized boolean cancel() {
        if (this.closed) {
            return false;
        }
        LOG.debug("Cancelling transaction {}", (Object)this.identifier);
        if (this.openCursor != null) {
            this.openCursor.close();
        }
        for (DOMDataTreeShardWriteTransaction tx : this.transactions.values()) {
            tx.close();
        }
        this.closed = true;
        this.producer.cancelTransaction(this);
        return true;
    }

    public synchronized DOMDataTreeWriteCursor createCursor(DOMDataTreeIdentifier prefix) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Transaction is closed already");
        Preconditions.checkState((this.openCursor == null ? 1 : 0) != 0, (Object)"There is still a cursor open");
        Preconditions.checkArgument((!this.producer.isDelegatedToChild(prefix) ? 1 : 0) != 0, (String)"Path %s is delegated to child producer.", (Object)prefix);
        DOMDataTreeShardWriteTransaction lookup = this.lookup(prefix);
        Preconditions.checkArgument((lookup != null ? 1 : 0) != 0, (String)"Path %s is not accessible from transaction %s", (Object)prefix, (Object)this);
        this.openCursor = new DelegatingCursor(lookup.createCursor(prefix), prefix);
        return this.openCursor;
    }

    public synchronized FluentFuture<? extends @NonNull CommitInfo> commit() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Transaction %s is already closed", (Object)this.identifier);
        Preconditions.checkState((this.openCursor == null ? 1 : 0) != 0, (Object)"Cannot submit transaction while there is a cursor open");
        this.producer.transactionSubmitted(this);
        return FluentFuture.from(this.future);
    }

    void doSubmit(final Consumer<ShardedDOMDataTreeWriteTransaction> success, final BiConsumer<ShardedDOMDataTreeWriteTransaction, Throwable> failure) {
        ListenableFuture internalFuture;
        LOG.debug("Readying tx {}", (Object)this.identifier);
        switch (this.transactions.size()) {
            case 0: {
                success.accept(this);
                return;
            }
            case 1: {
                DOMDataTreeShardWriteTransaction tx2 = this.transactions.values().iterator().next();
                tx2.ready();
                internalFuture = tx2.submit();
                break;
            }
            default: {
                internalFuture = Futures.allAsList((Iterable)this.transactions.values().stream().map(tx -> {
                    tx.ready();
                    return tx.submit();
                }).collect(Collectors.toList()));
            }
        }
        Futures.addCallback((ListenableFuture)internalFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                success.accept(ShardedDOMDataTreeWriteTransaction.this);
            }

            public void onFailure(Throwable exp) {
                failure.accept(ShardedDOMDataTreeWriteTransaction.this, exp);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    void onTransactionSuccess(CommitInfo commitInfo) {
        this.future.set((Object)commitInfo);
    }

    void onTransactionFailure(Throwable throwable) {
        this.future.setException(throwable);
    }

    synchronized void cursorClosed() {
        this.openCursor = null;
    }

    ProducerLayout getLayout() {
        return this.layout;
    }

    private class DelegatingCursor
    implements DOMDataTreeWriteCursor {
        private final Deque<YangInstanceIdentifier.PathArgument> currentArgs = new ArrayDeque<YangInstanceIdentifier.PathArgument>();
        private final DOMDataTreeWriteCursor delegate;
        private final DOMDataTreeIdentifier rootPosition;

        DelegatingCursor(DOMDataTreeWriteCursor delegate, DOMDataTreeIdentifier rootPosition) {
            this.delegate = Objects.requireNonNull(delegate);
            this.rootPosition = Objects.requireNonNull(rootPosition);
            this.currentArgs.addAll(rootPosition.getRootIdentifier().getPathArguments());
        }

        public void enter(YangInstanceIdentifier.PathArgument child) {
            this.checkAvailable(child);
            this.delegate.enter(child);
            this.currentArgs.push(child);
        }

        public void enter(YangInstanceIdentifier.PathArgument ... path) {
            for (YangInstanceIdentifier.PathArgument pathArgument : path) {
                this.enter(pathArgument);
            }
        }

        public void enter(Iterable<YangInstanceIdentifier.PathArgument> path) {
            for (YangInstanceIdentifier.PathArgument pathArgument : path) {
                this.enter(pathArgument);
            }
        }

        public void exit() {
            this.delegate.exit();
            this.currentArgs.pop();
        }

        public void exit(int depth) {
            this.delegate.exit(depth);
            for (int i = 0; i < depth; ++i) {
                this.currentArgs.pop();
            }
        }

        public void close() {
            int depthEntered = this.currentArgs.size() - this.rootPosition.getRootIdentifier().getPathArguments().size();
            if (depthEntered > 0) {
                this.delegate.exit(depthEntered);
            }
            this.delegate.close();
            ShardedDOMDataTreeWriteTransaction.this.cursorClosed();
        }

        public void delete(YangInstanceIdentifier.PathArgument child) {
            this.checkAvailable(child);
            this.delegate.delete(child);
        }

        public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
            this.checkAvailable(child);
            this.delegate.merge(child, data);
        }

        public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
            this.checkAvailable(child);
            this.delegate.write(child, data);
        }

        void checkAvailable(YangInstanceIdentifier.PathArgument child) {
            ShardedDOMDataTreeWriteTransaction.this.layout.checkAvailable(this.currentArgs, child);
        }
    }
}

