/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public final class DataSchemaContextTree {
    private static final LoadingCache<SchemaContext, DataSchemaContextTree> TREES = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<SchemaContext, DataSchemaContextTree>(){

        public DataSchemaContextTree load(SchemaContext key) throws Exception {
            return new DataSchemaContextTree(key);
        }
    });
    private final DataSchemaContextNode<?> root;

    private DataSchemaContextTree(SchemaContext ctx) {
        this.root = DataSchemaContextNode.from(ctx);
    }

    public static @NonNull DataSchemaContextTree from(@NonNull SchemaContext ctx) {
        return (DataSchemaContextTree)TREES.getUnchecked((Object)ctx);
    }

    public @NonNull Optional<@NonNull DataSchemaContextNode<?>> findChild(@NonNull YangInstanceIdentifier path) {
        return this.getRoot().findChild(path);
    }

    @Deprecated(forRemoval=true)
    public @Nullable DataSchemaContextNode<?> getChild(YangInstanceIdentifier path) {
        DataSchemaContextNode<?> currentOp = this.root;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            if ((currentOp = currentOp.getChild(arg)) != null) continue;
            return null;
        }
        return currentOp;
    }

    public DataSchemaContextNode<?> getRoot() {
        return this.root;
    }
}

