/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.spi;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.spi.ForwardingTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class ForwardingReadWriteTransaction
extends ForwardingTransaction
implements ReadWriteTransaction {
    private final ReadWriteTransaction delegate;

    public ForwardingReadWriteTransaction(ReadWriteTransaction delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    protected ReadWriteTransaction delegate() {
        return this.delegate;
    }

    public <T extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        this.delegate.put(store, path, data);
    }

    public <T extends DataObject> void mergeParentStructurePut(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        this.delegate.mergeParentStructurePut(store, path, data);
    }

    public <T extends DataObject> FluentFuture<Optional<T>> read(LogicalDatastoreType store, InstanceIdentifier<T> path) {
        return this.delegate.read(store, path);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        return this.delegate.exists(store, path);
    }

    public boolean cancel() {
        return this.delegate.cancel();
    }

    public <T extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        this.delegate.merge(store, path, data);
    }

    public <T extends DataObject> void mergeParentStructureMerge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
        this.delegate.mergeParentStructureMerge(store, path, data);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return this.delegate.commit();
    }

    public void delete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        this.delegate.delete(store, path);
    }
}

