/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeUpdatedBuilder
implements Builder<NodeUpdated> {
    private NodeId _id;
    private Map<NodeConnectorKey, NodeConnector> _nodeConnector;
    private NodeRef _nodeRef;
    Map<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> augmentation = Collections.emptyMap();

    public NodeUpdatedBuilder() {
    }

    public NodeUpdatedBuilder(Node arg) {
        this._id = arg.getId();
        this._nodeConnector = arg.getNodeConnector();
    }

    public NodeUpdatedBuilder(NodeUpdated base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>(aug);
        }
        this._id = base.getId();
        this._nodeConnector = base.getNodeConnector();
        this._nodeRef = base.getNodeRef();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Node) {
            this._id = ((Node)arg).getId();
            this._nodeConnector = ((Node)arg).getNodeConnector();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node]");
    }

    public NodeId getId() {
        return this._id;
    }

    public Map<NodeConnectorKey, NodeConnector> getNodeConnector() {
        return this._nodeConnector;
    }

    public NodeRef getNodeRef() {
        return this._nodeRef;
    }

    public <E$$ extends Augmentation<NodeUpdated>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodeUpdatedBuilder setId(NodeId value) {
        this._id = value;
        return this;
    }

    public NodeUpdatedBuilder setNodeConnector(Map<NodeConnectorKey, NodeConnector> values) {
        this._nodeConnector = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NodeUpdatedBuilder setNodeConnector(List<NodeConnector> values) {
        return this.setNodeConnector(CodeHelpers.compatMap(values));
    }

    public NodeUpdatedBuilder setNodeRef(NodeRef value) {
        this._nodeRef = value;
        return this;
    }

    public NodeUpdatedBuilder addAugmentation(Augmentation<NodeUpdated> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public NodeUpdatedBuilder addAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType, Augmentation<NodeUpdated> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public NodeUpdatedBuilder removeAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private NodeUpdatedBuilder doAddAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType, Augmentation<NodeUpdated> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeUpdated build() {
        return new NodeUpdatedImpl(this);
    }

    @Deprecated
    private static final class NodeUpdatedImpl
    extends AbstractAugmentable<NodeUpdated>
    implements NodeUpdated {
        private final NodeId _id;
        private final Map<NodeConnectorKey, NodeConnector> _nodeConnector;
        private final NodeRef _nodeRef;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeUpdatedImpl(NodeUpdatedBuilder base) {
            super(base.augmentation);
            this._id = base.getId();
            this._nodeConnector = CodeHelpers.emptyToNull(base.getNodeConnector());
            this._nodeRef = base.getNodeRef();
        }

        @Override
        public NodeId getId() {
            return this._id;
        }

        @Override
        public Map<NodeConnectorKey, NodeConnector> getNodeConnector() {
            return this._nodeConnector;
        }

        @Override
        public NodeRef getNodeRef() {
            return this._nodeRef;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._nodeConnector);
            result = 31 * result + Objects.hashCode(this._nodeRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeUpdated.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            NodeUpdated other = (NodeUpdated)obj;
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._nodeConnector, other.getNodeConnector())) {
                return false;
            }
            if (!Objects.equals(this._nodeRef, other.getNodeRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeUpdatedImpl otherImpl = (NodeUpdatedImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NodeUpdated");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_id", (Object)this._id);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeConnector", this._nodeConnector);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nodeRef", (Object)this._nodeRef);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

