/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.primitives.UnsignedLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.DurationWithTime;

class ConcurrentDurationStatisticsTracker
extends DurationStatisticsTracker {
    private static final AtomicReferenceFieldUpdater<ConcurrentDurationStatisticsTracker, DurationWithTime> LONGEST_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcurrentDurationStatisticsTracker.class, DurationWithTime.class, "longest");
    private static final AtomicReferenceFieldUpdater<ConcurrentDurationStatisticsTracker, DurationWithTime> SHORTEST_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConcurrentDurationStatisticsTracker.class, DurationWithTime.class, "shortest");
    private static final AtomicLongFieldUpdater<ConcurrentDurationStatisticsTracker> COUNT_UPDATER = AtomicLongFieldUpdater.newUpdater(ConcurrentDurationStatisticsTracker.class, "count");
    private static final AtomicLongFieldUpdater<ConcurrentDurationStatisticsTracker> SUM_UPDATER = AtomicLongFieldUpdater.newUpdater(ConcurrentDurationStatisticsTracker.class, "sum");
    private volatile long sum = 0L;
    private volatile long count = 0L;
    private volatile DurationWithTime longest = null;
    private volatile DurationWithTime shortest = null;

    ConcurrentDurationStatisticsTracker() {
    }

    @Override
    public final void addDuration(long duration) {
        block3: {
            DurationWithTime newObj;
            SUM_UPDATER.addAndGet(this, duration);
            COUNT_UPDATER.incrementAndGet(this);
            DurationWithTime current = this.shortest;
            if (current == null || duration < current.getDuration()) {
                newObj = new DurationWithTime(duration, System.currentTimeMillis());
                while (!(SHORTEST_UPDATER.weakCompareAndSet(this, current, newObj) || (current = this.shortest) != null && duration >= current.getDuration())) {
                }
            }
            if ((current = this.longest) != null && duration <= current.getDuration()) break block3;
            newObj = new DurationWithTime(duration, System.currentTimeMillis());
            while (!(LONGEST_UPDATER.weakCompareAndSet(this, current, newObj) || (current = this.longest) != null && duration <= current.getDuration())) {
            }
        }
    }

    @Override
    public final long getTotalDurations() {
        return this.count;
    }

    @Override
    public final double getAverageDuration() {
        long myCount = this.count;
        return myCount == 0L ? 0.0 : UnsignedLong.fromLongBits((long)this.sum).doubleValue() / (double)myCount;
    }

    @Override
    public final synchronized void reset() {
        this.longest = null;
        this.shortest = null;
        this.count = 0L;
        this.sum = 0L;
    }

    @Override
    protected final DurationWithTime getLongest() {
        return this.longest;
    }

    @Override
    protected final DurationWithTime getShortest() {
        return this.shortest;
    }
}

