/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.transformer;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.AbstractNormalizedNodePruner;
import org.opendaylight.controller.cluster.datastore.node.utils.transformer.UintAdaptingPruner;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Beta
public abstract class ReusableNormalizedNodePruner
extends AbstractNormalizedNodePruner {
    ReusableNormalizedNodePruner(SchemaContext schemaContext) {
        super(schemaContext);
    }

    ReusableNormalizedNodePruner(DataSchemaContextTree tree) {
        super(tree);
    }

    public static @NonNull ReusableNormalizedNodePruner forSchemaContext(SchemaContext schemaContext) {
        return new SimplePruner(schemaContext);
    }

    public static @NonNull ReusableNormalizedNodePruner forDataSchemaContext(DataSchemaContextTree tree) {
        return new SimplePruner(tree);
    }

    public abstract @NonNull ReusableNormalizedNodePruner duplicate();

    public final void initializeForPath(YangInstanceIdentifier path) {
        this.initialize(path);
    }

    public final @NonNull ReusableNormalizedNodePruner withUintAdaption() {
        return new UintAdaptingPruner(this.getTree());
    }

    private static final class SimplePruner
    extends ReusableNormalizedNodePruner {
        SimplePruner(SchemaContext schemaContext) {
            super(schemaContext);
        }

        SimplePruner(DataSchemaContextTree tree) {
            super(tree);
        }

        @Override
        public ReusableNormalizedNodePruner duplicate() {
            return new SimplePruner(this.getTree());
        }
    }
}

