/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.FinalizablePhantomReference;
import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.collect.Sets;
import com.google.common.io.ByteSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(FileBackedOutputStream.class);
    @VisibleForTesting
    static final Set<Cleanup> REFERENCE_CACHE = Sets.newConcurrentHashSet();
    private static final FinalizableReferenceQueue REFERENCE_QUEUE = new FinalizableReferenceQueue();
    private final int fileThreshold;
    private final String fileDirectory;
    private @GuardedBy(value={"this"}) MemoryOutputStream memory = new MemoryOutputStream();
    private @GuardedBy(value={"this"}) OutputStream out = this.memory;
    private @GuardedBy(value={"this"}) File file;
    private @GuardedBy(value={"this"}) ByteSource source;
    private volatile long count;

    public FileBackedOutputStream(int fileThreshold, @Nullable String fileDirectory) {
        this.fileThreshold = fileThreshold;
        this.fileDirectory = fileDirectory;
    }

    public synchronized @NonNull ByteSource asByteSource() throws IOException {
        this.close();
        if (this.source == null) {
            this.source = new ByteSource(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public InputStream openStream() throws IOException {
                    FileBackedOutputStream fileBackedOutputStream = FileBackedOutputStream.this;
                    synchronized (fileBackedOutputStream) {
                        if (FileBackedOutputStream.this.file != null) {
                            return Files.newInputStream(FileBackedOutputStream.this.file.toPath(), new OpenOption[0]);
                        }
                        return new ByteArrayInputStream(FileBackedOutputStream.this.memory.getBuffer(), 0, FileBackedOutputStream.this.memory.getCount());
                    }
                }

                public long size() {
                    return FileBackedOutputStream.this.count;
                }
            };
        }
        return this.source;
    }

    @Override
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Findbugs erroneously complains that the increment of count needs to be atomic even though it is inside a synchronized block.")
    public synchronized void write(int value) throws IOException {
        this.possiblySwitchToFile(1);
        this.out.write(value);
        ++this.count;
    }

    @Override
    public synchronized void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public synchronized void write(byte[] bytes, int off, int len) throws IOException {
        this.possiblySwitchToFile(len);
        this.out.write(bytes, off, len);
        this.count += (long)len;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.out != null) {
            OutputStream closeMe = this.out;
            this.out = null;
            closeMe.close();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    public synchronized void cleanup() {
        LOG.debug("In cleanup");
        this.closeQuietly();
        if (this.file != null) {
            Iterator<Cleanup> iter = REFERENCE_CACHE.iterator();
            while (iter.hasNext()) {
                if (!this.file.equals(iter.next().file)) continue;
                iter.remove();
                break;
            }
            LOG.debug("cleanup - deleting temp file {}", (Object)this.file);
            FileBackedOutputStream.deleteFile(this.file);
            this.file = null;
        }
    }

    @Holding(value={"this"})
    private void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing output stream {}", (Object)this.out, (Object)e);
        }
    }

    @Holding(value={"this"})
    private void possiblySwitchToFile(int len) throws IOException {
        if (this.out == null) {
            throw new IOException("Stream already closed");
        }
        if (this.file == null && this.memory.getCount() + len > this.fileThreshold) {
            File temp = File.createTempFile("FileBackedOutputStream", null, this.fileDirectory == null ? null : new File(this.fileDirectory));
            temp.deleteOnExit();
            LOG.debug("Byte count {} has exceeded threshold {} - switching to file: {}", new Object[]{this.memory.getCount() + len, this.fileThreshold, temp});
            OutputStream transfer = null;
            try {
                transfer = Files.newOutputStream(temp.toPath(), new OpenOption[0]);
                transfer.write(this.memory.getBuffer(), 0, this.memory.getCount());
                transfer.flush();
                this.out = transfer;
                this.file = temp;
                this.memory = null;
                new Cleanup(this, this.file);
            }
            catch (IOException e) {
                if (transfer != null) {
                    try {
                        transfer.close();
                    }
                    catch (IOException ex) {
                        LOG.debug("Error closing temp file {}", (Object)temp, (Object)ex);
                    }
                }
                FileBackedOutputStream.deleteFile(temp);
                throw e;
            }
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete()) {
            LOG.warn("Could not delete temp file {}", (Object)file);
        }
    }

    private static class Cleanup
    extends FinalizablePhantomReference<FileBackedOutputStream> {
        private final File file;

        Cleanup(FileBackedOutputStream referent, File file) {
            super((Object)referent, REFERENCE_QUEUE);
            this.file = file;
            REFERENCE_CACHE.add(this);
            LOG.debug("Added Cleanup for temp file {}", (Object)file);
        }

        public void finalizeReferent() {
            LOG.debug("In finalizeReferent");
            if (REFERENCE_CACHE.remove((Object)this)) {
                LOG.debug("finalizeReferent - deleting temp file {}", (Object)this.file);
                FileBackedOutputStream.deleteFile(this.file);
            }
        }
    }

    private static class MemoryOutputStream
    extends ByteArrayOutputStream {
        private MemoryOutputStream() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }
    }
}

