/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.BuyCarOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarBoughtBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarPurchaseService;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurchaseCarProvider
implements CarPurchaseService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PurchaseCarProvider.class);
    private final NotificationPublishService notificationProvider;

    public PurchaseCarProvider(NotificationPublishService notificationProvider) {
        this.notificationProvider = Objects.requireNonNull(notificationProvider);
    }

    public ListenableFuture<RpcResult<BuyCarOutput>> buyCar(BuyCarInput input) {
        LOG.info("Routed RPC buyCar : generating notification for buying car [{}]", (Object)input);
        return Futures.transform((ListenableFuture)this.notificationProvider.offerNotification((Notification)new CarBoughtBuilder().setCarId(input.getCarId()).setPersonId(input.getPersonId()).build()), result -> RpcResultBuilder.success((Object)new BuyCarOutputBuilder().build()).build(), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
    }
}

