/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.opendaylight.controller.cluster.datastore.exceptions.TimeoutException;
import org.opendaylight.controller.cluster.dom.api.CDSDataTreeProducer;
import org.opendaylight.controller.cluster.dom.api.CDSShardAccess;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.BecomePrefixLeaderInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.BecomePrefixLeaderOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.BecomePrefixLeaderOutputBuilder;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixLeaderHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixLeaderHandler.class);
    private final DOMDataTreeService domDataTreeService;
    private final BindingNormalizedNodeSerializer serializer;

    public PrefixLeaderHandler(DOMDataTreeService domDataTreeService, BindingNormalizedNodeSerializer serializer) {
        this.domDataTreeService = domDataTreeService;
        this.serializer = serializer;
    }

    public ListenableFuture<RpcResult<BecomePrefixLeaderOutput>> makeLeaderLocal(BecomePrefixLeaderInput input) {
        YangInstanceIdentifier yid = this.serializer.toYangInstanceIdentifier(input.getPrefix());
        DOMDataTreeIdentifier prefix = new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, yid);
        try (CDSDataTreeProducer producer = (CDSDataTreeProducer)this.domDataTreeService.createProducer(Collections.singleton(prefix));){
            CDSShardAccess shardAccess = producer.getShardAccess(prefix);
            CompletionStage completionStage = shardAccess.makeLeaderLocal();
            completionStage.exceptionally(throwable -> {
                LOG.error("Leader movement failed.", throwable);
                return null;
            });
        }
        catch (DOMDataTreeProducerException e) {
            LOG.warn("Error while closing producer", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout while on producer operation", (Throwable)e);
            Futures.immediateFuture((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, "resource-denied-transport", "Timeout while opening producer please retry.", "clustering-it", "clustering-it", (Throwable)e));
        }
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new BecomePrefixLeaderOutputBuilder().build()).build());
    }
}

