/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorRef;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.raft.GetSnapshotReplyActor;
import org.opendaylight.controller.cluster.raft.ImmutableElectionTerm;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftActorSnapshotCohort;
import org.opendaylight.controller.cluster.raft.base.messages.ApplySnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshot;
import org.opendaylight.controller.cluster.raft.base.messages.CaptureSnapshotReply;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshot;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshotReply;
import org.opendaylight.controller.cluster.raft.persisted.EmptyState;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;
import org.slf4j.Logger;
import scala.concurrent.duration.FiniteDuration;

class RaftActorSnapshotMessageSupport {
    static final Object COMMIT_SNAPSHOT = new Object(){

        public String toString() {
            return "commit_snapshot";
        }
    };
    private final RaftActorContext context;
    private final RaftActorSnapshotCohort cohort;
    private final Logger log;
    private FiniteDuration snapshotReplyActorTimeout = FiniteDuration.create((long)30L, (TimeUnit)TimeUnit.SECONDS);

    RaftActorSnapshotMessageSupport(RaftActorContext context, RaftActorSnapshotCohort cohort) {
        this.context = context;
        this.cohort = cohort;
        this.log = context.getLogger();
        context.getSnapshotManager().setCreateSnapshotConsumer(outputStream -> cohort.createSnapshot(context.getActor(), (Optional<OutputStream>)outputStream));
        context.getSnapshotManager().setSnapshotCohort(cohort);
    }

    RaftActorSnapshotCohort getSnapshotCohort() {
        return this.cohort;
    }

    boolean handleSnapshotMessage(Object message, ActorRef sender) {
        if (message instanceof ApplySnapshot) {
            this.onApplySnapshot((ApplySnapshot)message);
        } else if (message instanceof SaveSnapshotSuccess) {
            this.onSaveSnapshotSuccess((SaveSnapshotSuccess)message);
        } else if (message instanceof SaveSnapshotFailure) {
            this.onSaveSnapshotFailure((SaveSnapshotFailure)message);
        } else if (message instanceof CaptureSnapshotReply) {
            this.onCaptureSnapshotReply((CaptureSnapshotReply)message);
        } else if (COMMIT_SNAPSHOT.equals(message)) {
            this.context.getSnapshotManager().commit(-1L, -1L);
        } else if (message instanceof GetSnapshot) {
            this.onGetSnapshot(sender, (GetSnapshot)message);
        } else {
            return false;
        }
        return true;
    }

    private void onCaptureSnapshotReply(CaptureSnapshotReply reply) {
        this.log.debug("{}: CaptureSnapshotReply received by actor", (Object)this.context.getId());
        this.context.getSnapshotManager().persist(reply.getSnapshotState(), reply.getInstallSnapshotStream(), this.context.getTotalMemory());
    }

    private void onSaveSnapshotFailure(SaveSnapshotFailure saveSnapshotFailure) {
        this.log.error("{}: SaveSnapshotFailure received for snapshot Cause:", (Object)this.context.getId(), (Object)saveSnapshotFailure.cause());
        this.context.getSnapshotManager().rollback();
    }

    private void onSaveSnapshotSuccess(SaveSnapshotSuccess success) {
        long sequenceNumber = success.metadata().sequenceNr();
        this.log.info("{}: SaveSnapshotSuccess received for snapshot, sequenceNr: {}", (Object)this.context.getId(), (Object)sequenceNumber);
        this.context.getSnapshotManager().commit(sequenceNumber, success.metadata().timestamp());
    }

    private void onApplySnapshot(ApplySnapshot message) {
        this.log.info("{}: Applying snapshot on follower:  {}", (Object)this.context.getId(), (Object)message.getSnapshot());
        this.context.getSnapshotManager().apply(message);
    }

    private void onGetSnapshot(ActorRef sender, GetSnapshot getSnapshot) {
        this.log.debug("{}: onGetSnapshot", (Object)this.context.getId());
        if (this.context.getPersistenceProvider().isRecoveryApplicable()) {
            CaptureSnapshot captureSnapshot = this.context.getSnapshotManager().newCaptureSnapshot(this.context.getReplicatedLog().last(), -1L, true);
            FiniteDuration timeout = getSnapshot.getTimeout().map(Timeout::duration).orElse(this.snapshotReplyActorTimeout);
            ActorRef snapshotReplyActor = this.context.actorOf(GetSnapshotReplyActor.props(captureSnapshot, ImmutableElectionTerm.copyOf(this.context.getTermInformation()), sender, timeout, this.context.getId(), this.context.getPeerServerInfo(true)));
            this.cohort.createSnapshot(snapshotReplyActor, Optional.empty());
        } else {
            Snapshot snapshot = Snapshot.create(EmptyState.INSTANCE, Collections.emptyList(), -1L, -1L, -1L, -1L, this.context.getTermInformation().getCurrentTerm(), this.context.getTermInformation().getVotedFor(), this.context.getPeerServerInfo(true));
            sender.tell((Object)new GetSnapshotReply(this.context.getId(), snapshot), this.context.getActor());
        }
    }

    @VisibleForTesting
    void setSnapshotReplyActorTimeout(FiniteDuration snapshotReplyActorTimeout) {
        this.snapshotReplyActorTimeout = snapshotReplyActorTimeout;
    }
}

