/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.FollowerLogInformation;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftActorLeadershipTransferCohort;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.base.messages.TimeoutNow;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractLeader;
import org.opendaylight.controller.cluster.raft.behaviors.IsolatedLeader;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;

public class Leader
extends AbstractLeader {
    @VisibleForTesting
    static final Object ISOLATED_LEADER_CHECK = new Object();
    private final Stopwatch isolatedLeaderCheck = Stopwatch.createStarted();
    private @Nullable LeadershipTransferContext leadershipTransferContext;

    Leader(RaftActorContext context, @Nullable AbstractLeader initializeFromLeader) {
        super(context, RaftState.Leader, initializeFromLeader);
    }

    public Leader(RaftActorContext context) {
        this(context, (AbstractLeader)null);
    }

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object originalMessage) {
        Objects.requireNonNull(sender, "sender should not be null");
        if (ISOLATED_LEADER_CHECK.equals(originalMessage)) {
            if (this.isLeaderIsolated()) {
                this.log.warn("{}: At least {} followers need to be active, Switching {} from Leader to IsolatedLeader", new Object[]{this.context.getId(), this.getMinIsolatedLeaderPeerCount(), this.getLeaderId()});
                return this.internalSwitchBehavior(new IsolatedLeader(this.context, this));
            }
            return this;
        }
        return super.handleMessage(sender, originalMessage);
    }

    @Override
    protected void beforeSendHeartbeat() {
        if (this.isolatedLeaderCheck.elapsed(TimeUnit.MILLISECONDS) > this.context.getConfigParams().getIsolatedCheckIntervalInMillis()) {
            this.context.getActor().tell(ISOLATED_LEADER_CHECK, this.context.getActor());
            this.isolatedLeaderCheck.reset().start();
        }
        if (this.leadershipTransferContext != null && this.leadershipTransferContext.isExpired(this.context.getConfigParams().getElectionTimeOutInterval().toMillis())) {
            this.log.debug("{}: Leadership transfer expired", (Object)this.logName());
            this.leadershipTransferContext = null;
        }
    }

    @Override
    protected RaftActorBehavior handleAppendEntriesReply(ActorRef sender, AppendEntriesReply appendEntriesReply) {
        RaftActorBehavior returnBehavior = super.handleAppendEntriesReply(sender, appendEntriesReply);
        this.tryToCompleteLeadershipTransfer(appendEntriesReply.getFollowerId());
        return returnBehavior;
    }

    public void transferLeadership(@NonNull RaftActorLeadershipTransferCohort leadershipTransferCohort) {
        this.log.debug("{}: Attempting to transfer leadership", (Object)this.logName());
        this.leadershipTransferContext = new LeadershipTransferContext(leadershipTransferCohort);
        this.sendAppendEntries(0L, false);
    }

    private void tryToCompleteLeadershipTransfer(String followerId) {
        if (this.leadershipTransferContext == null) {
            return;
        }
        Optional<String> requestedFollowerIdOptional = this.leadershipTransferContext.transferCohort.getRequestedFollowerId();
        if (requestedFollowerIdOptional.isPresent() && !requestedFollowerIdOptional.get().equals(followerId)) {
            return;
        }
        FollowerLogInformation followerInfo = this.getFollower(followerId);
        if (followerInfo == null) {
            return;
        }
        long lastIndex = this.context.getReplicatedLog().lastIndex();
        boolean isVoting = this.context.getPeerInfo(followerId).isVoting();
        this.log.debug("{}: tryToCompleteLeadershipTransfer: followerId: {}, matchIndex: {}, lastIndex: {}, isVoting: {}", new Object[]{this.logName(), followerId, followerInfo.getMatchIndex(), lastIndex, isVoting});
        if (isVoting && followerInfo.getMatchIndex() == lastIndex) {
            this.log.debug("{}: Follower's log matches - sending ElectionTimeout", (Object)this.logName());
            this.sendAppendEntries(0L, false);
            ActorSelection followerActor = this.context.getPeerActorSelection(followerId);
            followerActor.tell((Object)TimeoutNow.INSTANCE, this.context.getActor());
            this.log.debug("{}: Leader transfer complete", (Object)this.logName());
            this.leadershipTransferContext.transferCohort.transferComplete();
            this.leadershipTransferContext = null;
        }
    }

    @Override
    public void close() {
        if (this.leadershipTransferContext != null) {
            LeadershipTransferContext localLeadershipTransferContext = this.leadershipTransferContext;
            this.leadershipTransferContext = null;
            localLeadershipTransferContext.transferCohort.abortTransfer();
        }
        super.close();
    }

    @VisibleForTesting
    void markFollowerActive(String followerId) {
        this.getFollower(followerId).markFollowerActive();
    }

    @VisibleForTesting
    void markFollowerInActive(String followerId) {
        this.getFollower(followerId).markFollowerInActive();
    }

    private static class LeadershipTransferContext {
        RaftActorLeadershipTransferCohort transferCohort;
        Stopwatch timer = Stopwatch.createStarted();

        LeadershipTransferContext(RaftActorLeadershipTransferCohort transferCohort) {
            this.transferCohort = transferCohort;
        }

        boolean isExpired(long timeout) {
            if (this.timer.elapsed(TimeUnit.MILLISECONDS) >= timeout) {
                this.transferCohort.abortTransfer();
                return true;
            }
            return false;
        }
    }
}

