/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class DOMActionInstance
implements Immutable {
    private final Set<DOMDataTreeIdentifier> dataTrees;
    private final SchemaPath type;

    DOMActionInstance(SchemaPath type, Set<DOMDataTreeIdentifier> dataTrees) {
        this.type = Objects.requireNonNull(type);
        this.dataTrees = ImmutableSet.copyOf(dataTrees);
        Preconditions.checkArgument((!dataTrees.isEmpty() ? 1 : 0) != 0);
    }

    public static DOMActionInstance of(SchemaPath type, Set<DOMDataTreeIdentifier> dataTrees) {
        return new DOMActionInstance(type, dataTrees);
    }

    public static DOMActionInstance of(SchemaPath type, DOMDataTreeIdentifier ... dataTrees) {
        return DOMActionInstance.of(type, (Set<DOMDataTreeIdentifier>)ImmutableSet.copyOf((Object[])dataTrees));
    }

    public static DOMActionInstance of(SchemaPath type, LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        return DOMActionInstance.of(type, (Set<DOMDataTreeIdentifier>)ImmutableSet.of((Object)new DOMDataTreeIdentifier(datastore, path)));
    }

    public Set<DOMDataTreeIdentifier> getDataTrees() {
        return this.dataTrees;
    }

    public SchemaPath getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.dataTrees);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DOMActionInstance)) {
            return false;
        }
        DOMActionInstance other = (DOMActionInstance)obj;
        return this.getType().equals((Object)other.type) && this.dataTrees.equals(other.dataTrees);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("dataTrees", this.dataTrees).toString();
    }
}

