/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api.query;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public abstract class DOMQueryPredicate
implements Immutable,
Predicate<Object> {
    private final @NonNull YangInstanceIdentifier relativePath;

    DOMQueryPredicate(YangInstanceIdentifier relativePath) {
        this.relativePath = Objects.requireNonNull(relativePath);
    }

    public final @NonNull YangInstanceIdentifier getPath() {
        return this.relativePath;
    }

    @Override
    public abstract boolean test(@Nullable Object var1);

    public String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("path", (Object)this.relativePath)).toString();
    }

    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper;
    }

    public static final class MatchesPattern
    extends DOMQueryPredicate {
        private final Pattern pattern;

        public MatchesPattern(YangInstanceIdentifier relativePath, Pattern pattern) {
            super(relativePath);
            this.pattern = Objects.requireNonNull(pattern);
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("pattern", (Object)this.pattern);
        }

        @Override
        public boolean test(Object data) {
            return data instanceof CharSequence && this.pattern.matcher((CharSequence)data).matches();
        }
    }

    public static final class Contains
    extends AbstractStringDOMQueryPredicate {
        public Contains(YangInstanceIdentifier relativePath, String str) {
            super(relativePath, str);
        }

        @Override
        boolean test(String str) {
            return str.contains((CharSequence)this.value());
        }
    }

    public static final class EndsWith
    extends AbstractStringDOMQueryPredicate {
        public EndsWith(YangInstanceIdentifier relativePath, String str) {
            super(relativePath, str);
        }

        @Override
        boolean test(String str) {
            return str.endsWith((String)this.value());
        }
    }

    public static final class StartsWith
    extends AbstractStringDOMQueryPredicate {
        public StartsWith(YangInstanceIdentifier relativePath, String str) {
            super(relativePath, str);
        }

        @Override
        boolean test(String str) {
            return str.startsWith((String)this.value());
        }
    }

    public static final class LessThanOrEqual<T extends Comparable<T>>
    extends AbstractComparableDOMQueryPredicate<T> {
        public LessThanOrEqual(YangInstanceIdentifier relativePath, T value) {
            super(relativePath, value);
        }

        @Override
        boolean test(int valueToData) {
            return valueToData > 0;
        }
    }

    public static final class LessThan<T extends Comparable<T>>
    extends AbstractComparableDOMQueryPredicate<T> {
        public LessThan(YangInstanceIdentifier relativePath, T value) {
            super(relativePath, value);
        }

        @Override
        boolean test(int valueToData) {
            return valueToData >= 0;
        }
    }

    public static final class GreaterThanOrEqual<T extends Comparable<T>>
    extends AbstractComparableDOMQueryPredicate<T> {
        public GreaterThanOrEqual(YangInstanceIdentifier relativePath, T value) {
            super(relativePath, value);
        }

        @Override
        boolean test(int valueToData) {
            return valueToData < 0;
        }
    }

    public static final class GreaterThan<T extends Comparable<T>>
    extends AbstractComparableDOMQueryPredicate<T> {
        public GreaterThan(YangInstanceIdentifier relativePath, T value) {
            super(relativePath, value);
        }

        @Override
        boolean test(int valueToData) {
            return valueToData <= 0;
        }
    }

    public static final class ValueEquals<T>
    extends AbstractValueDOMQueryPredicate<T> {
        public ValueEquals(YangInstanceIdentifier relativePath, T value) {
            super(relativePath, value);
        }

        @Override
        public boolean test(Object data) {
            return this.value().equals(data);
        }
    }

    public static final class Exists
    extends DOMQueryPredicate {
        public Exists(YangInstanceIdentifier relativePath) {
            super(relativePath);
        }

        @Override
        public boolean test(Object data) {
            return data != null;
        }
    }

    static abstract class AbstractStringDOMQueryPredicate
    extends AbstractValueDOMQueryPredicate<String> {
        AbstractStringDOMQueryPredicate(YangInstanceIdentifier relativePath, String value) {
            super(relativePath, value);
        }

        @Override
        public final boolean test(Object data) {
            return data instanceof String && this.test((String)data);
        }

        @Override
        abstract boolean test(@NonNull String var1);
    }

    static abstract class AbstractComparableDOMQueryPredicate<T extends Comparable<T>>
    extends AbstractValueDOMQueryPredicate<T> {
        AbstractComparableDOMQueryPredicate(YangInstanceIdentifier relativePath, T value) {
            super(relativePath, value);
        }

        @Override
        public final boolean test(Object data) {
            return data != null && this.test(((Comparable)this.value()).compareTo((Comparable)data));
        }

        @Override
        abstract boolean test(int var1);
    }

    static abstract class AbstractValueDOMQueryPredicate<T>
    extends DOMQueryPredicate {
        private final @NonNull T value;

        AbstractValueDOMQueryPredicate(YangInstanceIdentifier relativePath, T value) {
            super(relativePath);
            this.value = Objects.requireNonNull(value);
        }

        final @NonNull T value() {
            return this.value;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("value", this.value);
        }
    }
}

