/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.spi.source;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.parser.spi.source.PrefixToModule;

public class PrefixToModuleMap
implements PrefixToModule {
    private final Map<String, QNameModule> prefixToModuleMap = new HashMap<String, QNameModule>();
    private final Map<URI, QNameModule> namespaceToModuleMap = new HashMap<URI, QNameModule>();

    public void put(String prefix, QNameModule module) {
        this.prefixToModuleMap.put(prefix, module);
        this.namespaceToModuleMap.put(module.getNamespace(), module);
    }

    @Override
    public QNameModule get(String prefix) {
        return this.prefixToModuleMap.get(prefix);
    }

    @Override
    public QNameModule getByNamespace(String namespace) throws URISyntaxException {
        return this.namespaceToModuleMap.get(new URI(namespace));
    }
}

