/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int.Item;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.target.rev170215.id.ints.id._int.ItemKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ItemBuilder
implements Builder<Item> {
    private Integer _number;
    private ItemKey key;
    Map<Class<? extends Augmentation<Item>>, Augmentation<Item>> augmentation = Collections.emptyMap();

    public ItemBuilder() {
    }

    public ItemBuilder(Item base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>(aug);
        }
        this.key = base.key();
        this._number = base.getNumber();
    }

    public ItemKey key() {
        return this.key;
    }

    public Integer getNumber() {
        return this._number;
    }

    public <E$$ extends Augmentation<Item>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ItemBuilder withKey(ItemKey key) {
        this.key = key;
        return this;
    }

    public ItemBuilder setNumber(Integer value) {
        this._number = value;
        return this;
    }

    public ItemBuilder addAugmentation(Augmentation<Item> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public ItemBuilder addAugmentation(Class<? extends Augmentation<Item>> augmentationType, Augmentation<Item> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public ItemBuilder removeAugmentation(Class<? extends Augmentation<Item>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private ItemBuilder doAddAugmentation(Class<? extends Augmentation<Item>> augmentationType, Augmentation<Item> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Item>>, Augmentation<Item>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Item build() {
        return new ItemImpl(this);
    }

    private static final class ItemImpl
    extends AbstractAugmentable<Item>
    implements Item {
        private final Integer _number;
        private final ItemKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ItemImpl(ItemBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ItemKey(base.getNumber());
            this._number = this.key.getNumber();
        }

        @Override
        public ItemKey key() {
            return this.key;
        }

        @Override
        public Integer getNumber() {
            return this._number;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._number);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Item.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Item other = (Item)obj;
            if (!Objects.equals(this._number, other.getNumber())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ItemImpl otherImpl = (ItemImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Item");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_number", (Object)this._number);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

