/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPerson;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.PersonId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class CarPersonBuilder
implements Builder<CarPerson> {
    private CarId _carId;
    private PersonId _personId;
    private CarPersonKey key;
    Map<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>> augmentation = Collections.emptyMap();

    public CarPersonBuilder() {
    }

    public CarPersonBuilder(CarPerson base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>(aug);
        }
        this.key = base.key();
        this._carId = base.getCarId();
        this._personId = base.getPersonId();
    }

    public CarPersonKey key() {
        return this.key;
    }

    public CarId getCarId() {
        return this._carId;
    }

    public PersonId getPersonId() {
        return this._personId;
    }

    public <E$$ extends Augmentation<CarPerson>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public CarPersonBuilder withKey(CarPersonKey key) {
        this.key = key;
        return this;
    }

    public CarPersonBuilder setCarId(CarId value) {
        this._carId = value;
        return this;
    }

    public CarPersonBuilder setPersonId(PersonId value) {
        this._personId = value;
        return this;
    }

    public CarPersonBuilder addAugmentation(Augmentation<CarPerson> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public CarPersonBuilder addAugmentation(Class<? extends Augmentation<CarPerson>> augmentationType, Augmentation<CarPerson> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public CarPersonBuilder removeAugmentation(Class<? extends Augmentation<CarPerson>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private CarPersonBuilder doAddAugmentation(Class<? extends Augmentation<CarPerson>> augmentationType, Augmentation<CarPerson> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public CarPerson build() {
        return new CarPersonImpl(this);
    }

    private static final class CarPersonImpl
    extends AbstractAugmentable<CarPerson>
    implements CarPerson {
        private final CarId _carId;
        private final PersonId _personId;
        private final CarPersonKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        CarPersonImpl(CarPersonBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new CarPersonKey(base.getCarId(), base.getPersonId());
            this._carId = this.key.getCarId();
            this._personId = this.key.getPersonId();
        }

        @Override
        public CarPersonKey key() {
            return this.key;
        }

        @Override
        public CarId getCarId() {
            return this._carId;
        }

        @Override
        public PersonId getPersonId() {
            return this._personId;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._carId);
            result = 31 * result + Objects.hashCode(this._personId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!CarPerson.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            CarPerson other = (CarPerson)obj;
            if (!Objects.equals(this._carId, other.getCarId())) {
                return false;
            }
            if (!Objects.equals(this._personId, other.getPersonId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                CarPersonImpl otherImpl = (CarPersonImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"CarPerson");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_carId", (Object)this._carId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_personId", (Object)this._personId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

