/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.binding.runtime.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.api.IncorrectNestingException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingClassInLoadingStrategyException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingSchemaException;
import org.opendaylight.mdsal.binding.dom.codec.api.MissingSchemaForClassException;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.CachingNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NonCachingCodec;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

abstract class DataContainerCodecContext<D extends DataObject, T extends DocumentedNode.WithStatus>
extends NodeCodecContext
implements BindingDataObjectCodecTreeNode<D> {
    private static final VarHandle EVENT_STREAM_SERIALIZER;
    private final @NonNull DataContainerCodecPrototype<T> prototype;
    private volatile DataObjectSerializer eventStreamSerializer;

    DataContainerCodecContext(DataContainerCodecPrototype<T> prototype) {
        this.prototype = Objects.requireNonNull(prototype);
    }

    public final T getSchema() {
        return this.prototype.getSchema();
    }

    public final BindingDataObjectCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.prototype.getChildAddressabilitySummary();
    }

    protected final QNameModule namespace() {
        return this.prototype.getNamespace();
    }

    protected final NodeCodecContext.CodecContextFactory factory() {
        return this.prototype.getFactory();
    }

    @Override
    protected YangInstanceIdentifier.PathArgument getDomPathArgument() {
        return this.prototype.getYangArg();
    }

    public abstract NodeCodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument var1);

    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        BindingDataObjectCodecTreeNode child = this.streamChild(arg.getType());
        if (builder != null) {
            child.addYangPathArgument(arg, builder);
        }
        return child;
    }

    protected InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        return this.bindingArg();
    }

    protected final InstanceIdentifier.PathArgument bindingArg() {
        return this.prototype.getBindingArg();
    }

    public final Class<D> getBindingClass() {
        return (Class)Class.class.cast(this.prototype.getBindingClass());
    }

    public abstract <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> var1);

    public abstract <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> var1);

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.prototype.getBindingClass() + "]";
    }

    public BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        if (cacheSpecifier.isEmpty()) {
            return new NonCachingCodec(this);
        }
        return new CachingNormalizedNodeCodec(this, (ImmutableSet<Class<? extends BindingObject>>)ImmutableSet.copyOf(cacheSpecifier));
    }

    @NonNull BindingStreamEventWriter createWriter(NormalizedNodeStreamWriter domWriter) {
        return BindingToNormalizedStreamWriter.create(this, domWriter);
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, YangInstanceIdentifier.PathArgument child, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(DataContainerCodecContext.extractName(child), message, args);
        }
        return nullable;
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, QName child, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(child, message, args);
        }
        return nullable;
    }

    protected final <V> @NonNull V childNonNull(@Nullable V nullable, Class<?> childClass, String message, Object ... args) {
        if (nullable == null) {
            throw this.childNullException(childClass, message, args);
        }
        return nullable;
    }

    private IllegalArgumentException childNullException(QName child, String message, Object ... args) {
        QNameModule module = child.getModule();
        if (!this.factory().getRuntimeContext().getSchemaContext().findModule(module).isPresent()) {
            throw new MissingSchemaException("Module " + module + " is not present in current schema context.");
        }
        throw IncorrectNestingException.create((String)message, (Object[])args);
    }

    private IllegalArgumentException childNullException(Class<?> childClass, String message, Object ... args) {
        BindingRuntimeContext runtimeContext = this.factory().getRuntimeContext();
        Object schema = Augmentation.class.isAssignableFrom(childClass) ? runtimeContext.getAugmentationDefinition(childClass) : runtimeContext.getSchemaDefinition(childClass);
        if (schema == null) {
            throw new MissingSchemaForClassException(childClass);
        }
        ClassLoadingStrategy strategy = runtimeContext.getStrategy();
        try {
            strategy.loadClass(childClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new MissingClassInLoadingStrategyException("User supplied class " + childClass.getName() + " is not available in " + strategy, (Throwable)e);
        }
        throw IncorrectNestingException.create((String)message, (Object[])args);
    }

    private static QName extractName(YangInstanceIdentifier.PathArgument child) {
        if (child instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            Set children = ((YangInstanceIdentifier.AugmentationIdentifier)child).getPossibleChildNames();
            Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"Augmentation without childs must not be used in data");
            return (QName)children.iterator().next();
        }
        return child.getNodeType();
    }

    final DataObjectSerializer eventStreamSerializer() {
        DataObjectSerializer existing = EVENT_STREAM_SERIALIZER.getAcquire(this);
        return existing != null ? existing : this.loadEventStreamSerializer();
    }

    private DataObjectSerializer loadEventStreamSerializer() {
        DataObjectSerializer loaded = this.factory().getEventStreamSerializer(this.getBindingClass());
        Object witness = EVENT_STREAM_SERIALIZER.compareAndExchangeRelease(this, null, loaded);
        return witness == null ? loaded : (DataObjectSerializer)witness;
    }

    public NormalizedNode<?, ?> serialize(D data) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        this.writeAsNormalizedNode(data, domWriter);
        return result.getResult();
    }

    public void writeAsNormalizedNode(D data, NormalizedNodeStreamWriter writer) {
        try {
            this.eventStreamSerializer().serialize((DataObject)data, this.createWriter(writer));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize Binding DTO", e);
        }
    }

    static {
        try {
            EVENT_STREAM_SERIALIZER = MethodHandles.lookup().findVarHandle(DataContainerCodecContext.class, "eventStreamSerializer", DataObjectSerializer.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

