/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingMap;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

abstract class KeyedListNodeCodecContext<I extends Identifier<D>, D extends DataObject & Identifiable<I>>
extends ListNodeCodecContext<D> {
    private final IdentifiableItemCodec codec;

    KeyedListNodeCodecContext(DataContainerCodecPrototype<ListSchemaNode> prototype, Method keyMethod, IdentifiableItemCodec codec) {
        super(prototype, keyMethod);
        this.codec = Objects.requireNonNull(codec);
    }

    static KeyedListNodeCodecContext create(DataContainerCodecPrototype<ListSchemaNode> prototype) {
        Method keyMethod;
        Class<?> bindingClass = prototype.getBindingClass();
        try {
            keyMethod = bindingClass.getMethod("key", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Required method not available", e);
        }
        ListSchemaNode schema = prototype.getSchema();
        IdentifiableItemCodec codec = prototype.getFactory().getPathArgumentCodec(bindingClass, schema);
        return schema.isUserOrdered() ? new Ordered(prototype, keyMethod, codec) : new Unordered(prototype, keyMethod, codec);
    }

    @Override
    protected void addYangPathArgument(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        if (builder == null) {
            return;
        }
        super.addYangPathArgument(arg, builder);
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            builder.add((YangInstanceIdentifier.PathArgument)this.codec.serialize((InstanceIdentifier.IdentifiableItem)arg));
        } else {
            super.addYangPathArgument(arg, builder);
        }
    }

    @Override
    protected InstanceIdentifier.PathArgument getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        if (domArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return (InstanceIdentifier.PathArgument)this.codec.deserialize((YangInstanceIdentifier.NodeIdentifierWithPredicates)domArg);
        }
        return super.getBindingPathArgument(domArg);
    }

    YangInstanceIdentifier.NodeIdentifierWithPredicates serialize(Identifier<?> key) {
        return (YangInstanceIdentifier.NodeIdentifierWithPredicates)this.codec.serialize(InstanceIdentifier.IdentifiableItem.of(this.getBindingClass(), key));
    }

    @NonNull Identifier<?> deserialize(YangInstanceIdentifier.NodeIdentifierWithPredicates arg) {
        return this.codec.deserializeIdentifier(arg);
    }

    @Override
    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        if (arg instanceof InstanceIdentifier.IdentifiableItem) {
            return (YangInstanceIdentifier.PathArgument)this.codec.serialize((InstanceIdentifier.IdentifiableItem)arg);
        }
        return super.serializePathArgument(arg);
    }

    @Override
    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return (InstanceIdentifier.PathArgument)this.codec.deserialize((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg);
        }
        return super.deserializePathArgument(arg);
    }

    static final class Unordered<I extends Identifier<D>, D extends DataObject & Identifiable<I>>
    extends KeyedListNodeCodecContext<I, D> {
        Unordered(DataContainerCodecPrototype<ListSchemaNode> prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }

        @Override
        Map<I, D> fromMap(MapNode map, int size) {
            return LazyBindingMap.create(this, map, size);
        }
    }

    private static final class Ordered<I extends Identifier<D>, D extends DataObject & Identifiable<I>>
    extends KeyedListNodeCodecContext<I, D> {
        Ordered(DataContainerCodecPrototype<ListSchemaNode> prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }
    }
}

