/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Instant;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentableCodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.ByteBuddyUtils;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.ByteBuddy;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.method.MethodList;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDefinition;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.description.type.TypeDescription;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.Implementation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.StackManipulation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.matcher.ElementMatchers;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EventInstantAware;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;

final class NotificationCodecContext<D extends DataObject & Notification>
extends DataObjectCodecContext<D, NotificationDefinition> {
    private static final TypeDescription.Generic EVENT_INSTANT_AWARE = TypeDefinition.Sort.describe(EventInstantAware.class);
    private static final String EVENT_INSTANT_NAME;
    private static final TypeDescription.Generic EVENT_INSTANT_RETTYPE;
    private static final TypeDescription.Generic BB_DOCC;
    private static final TypeDescription.Generic BB_NNC;
    private static final TypeDescription.Generic BB_I;
    private static final MethodType CONSTRUCTOR_TYPE;
    private static final MethodType NOTIFICATION_TYPE;
    private static final String INSTANT_FIELD = "instant";
    private final MethodHandle eventProxy;

    NotificationCodecContext(Class<?> key, NotificationDefinition schema, NodeCodecContext.CodecContextFactory factory) {
        super(DataContainerCodecPrototype.from(key, schema, factory));
        MethodHandle ctor;
        Class bindingClass = this.getBindingClass();
        Class awareClass = this.factory().getLoader().generateClass(bindingClass, "eventInstantAware", (loader, fqcn, bindingInterface) -> {
            Class<?> codecImpl = loader.getGeneratedClass(bindingClass, "codecImpl");
            return CodecClassLoader.GeneratorResult.of(new ByteBuddy().subclass(codecImpl, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).implement(EVENT_INSTANT_AWARE).name(fqcn).defineField(INSTANT_FIELD, (TypeDefinition)BB_I, 4114).defineConstructor(4097).withParameters(BB_DOCC, BB_NNC, BB_I).intercept(ConstructorImplementation.INSTANCE).defineMethod(EVENT_INSTANT_NAME, (TypeDefinition)EVENT_INSTANT_RETTYPE, 4097).intercept(EventInstantImplementation.INSTANCE).make());
        });
        try {
            ctor = MethodHandles.publicLookup().findConstructor(awareClass, CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to acquire constructor", e);
        }
        this.eventProxy = ctor.asType(NOTIFICATION_TYPE);
    }

    public D deserialize(NormalizedNode<?, ?> data) {
        Preconditions.checkState((boolean)(data instanceof ContainerNode));
        return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)((ContainerNode)data));
    }

    Notification deserialize(@NonNull ContainerNode data, @NonNull Instant eventInstant) {
        try {
            return this.eventProxy.invokeExact(this, data, eventInstant);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    static {
        MethodDescription eventInstance = (MethodDescription)EVENT_INSTANT_AWARE.getDeclaredMethods().getOnly();
        EVENT_INSTANT_NAME = eventInstance.getName();
        EVENT_INSTANT_RETTYPE = eventInstance.getReturnType();
        BB_DOCC = TypeDefinition.Sort.describe(DataObjectCodecContext.class);
        BB_NNC = TypeDefinition.Sort.describe(NormalizedNodeContainer.class);
        BB_I = TypeDefinition.Sort.describe(Instant.class);
        CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, DataObjectCodecContext.class, NormalizedNodeContainer.class, Instant.class);
        NOTIFICATION_TYPE = MethodType.methodType(Notification.class, NotificationCodecContext.class, ContainerNode.class, Instant.class);
    }

    private static enum EventInstantImplementation implements Implementation
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender.Simple(ByteBuddyUtils.THIS, ByteBuddyUtils.getField(implementationTarget.getInstrumentedType(), NotificationCodecContext.INSTANT_FIELD), MethodReturn.REFERENCE);
        }
    }

    private static enum ConstructorImplementation implements Implementation
    {
        INSTANCE;

        private static final StackManipulation INSTANT_ARG;
        private static final StackManipulation LOAD_CTOR_ARGS;

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            MethodDescription.InGenericShape superCtor = (MethodDescription.InGenericShape)((MethodList)instrumentedType.getSuperClass().getDeclaredMethods().filter(ElementMatchers.isConstructor())).getOnly();
            return new ByteCodeAppender.Simple(ByteBuddyUtils.THIS, LOAD_CTOR_ARGS, MethodInvocation.invoke(superCtor), ByteBuddyUtils.THIS, INSTANT_ARG, ByteBuddyUtils.putField(instrumentedType, NotificationCodecContext.INSTANT_FIELD), MethodReturn.VOID);
        }

        static {
            INSTANT_ARG = MethodVariableAccess.REFERENCE.loadFrom(3);
            try {
                LOAD_CTOR_ARGS = MethodVariableAccess.allArgumentsOf(new MethodDescription.ForLoadedConstructor(AugmentableCodecDataObject.class.getDeclaredConstructor(DataObjectCodecContext.class, NormalizedNodeContainer.class)));
            }
            catch (NoSuchMethodException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

