/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.UintConversions;

@Beta
@NonNullByDefault
public class Uint16
extends Number
implements CanonicalValue<Uint16> {
    private static final CanonicalValueSupport<Uint16> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final int MAX_VALUE_INT = 65535;
    private static final String MAX_VALUE_STR = "65535";
    private static final String CACHE_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint16.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 256;
    private static final int CACHE_SIZE;
    private static final @NonNull Uint16[] CACHE;
    private static final Interner<Uint16> INTERNER;
    public static final Uint16 ZERO;
    public static final Uint16 ONE;
    public static final Uint16 TWO;
    public static final Uint16 TEN;
    public static final Uint16 MAX_VALUE;
    private final short value;

    private Uint16(short value) {
        this.value = value;
    }

    protected Uint16(Uint16 other) {
        this(other.value);
    }

    private static Uint16 instanceFor(short value) {
        int slot = Short.toUnsignedInt(value);
        return slot < CACHE.length ? CACHE[slot] : new Uint16(value);
    }

    public static Uint16 fromShortBits(short bits) {
        return Uint16.instanceFor(bits);
    }

    public static Uint16 valueOf(byte byteVal) {
        UintConversions.checkNonNegative(byteVal, MAX_VALUE_STR);
        return Uint16.instanceFor(byteVal);
    }

    public static Uint16 valueOf(short shortVal) {
        UintConversions.checkNonNegative(shortVal, MAX_VALUE_STR);
        return Uint16.instanceFor(shortVal);
    }

    public static Uint16 valueOf(int intVal) {
        UintConversions.checkRange(intVal, 65535);
        return Uint16.instanceFor((short)intVal);
    }

    public static Uint16 valueOf(long longVal) {
        UintConversions.checkRange(longVal, 65535L);
        return Uint16.instanceFor((short)longVal);
    }

    public static Uint16 valueOf(Uint8 uint) {
        return Uint16.instanceFor(uint.shortValue());
    }

    public static Uint16 valueOf(Uint32 uint) {
        return Uint16.valueOf(uint.longValue());
    }

    public static Uint16 valueOf(Uint64 uint) {
        return Uint16.valueOf(uint.longValue());
    }

    public static Uint16 valueOf(String string) {
        return Uint16.valueOf(string, 10);
    }

    public static Uint16 valueOf(String string, int radix) {
        return Uint16.valueOf(Integer.parseInt(Objects.requireNonNull(string), radix));
    }

    public static Uint16 saturatedOf(byte byteVal) {
        return byteVal <= 0 ? ZERO : Uint16.instanceFor(byteVal);
    }

    public static Uint16 saturatedOf(short shortVal) {
        return shortVal <= 0 ? ZERO : Uint16.instanceFor(shortVal);
    }

    public static Uint16 saturatedOf(int intVal) {
        if (intVal <= 0) {
            return ZERO;
        }
        if (intVal >= 65535) {
            return MAX_VALUE;
        }
        return Uint16.instanceFor((short)intVal);
    }

    public static Uint16 saturatedOf(long longVal) {
        if (longVal <= 0L) {
            return ZERO;
        }
        if (longVal >= 65535L) {
            return MAX_VALUE;
        }
        return Uint16.instanceFor((short)longVal);
    }

    @Override
    public final short shortValue() {
        return this.value;
    }

    @Override
    public final int intValue() {
        return Short.toUnsignedInt(this.value);
    }

    @Override
    public final long longValue() {
        return Short.toUnsignedLong(this.value);
    }

    @Override
    public final float floatValue() {
        return this.intValue();
    }

    @Override
    public final double doubleValue() {
        return this.intValue();
    }

    @Override
    public final int compareTo(Uint16 o) {
        return Short.compareUnsigned(this.value, o.value);
    }

    @Override
    public final String toCanonicalString() {
        return Integer.toString(this.intValue());
    }

    @Override
    public final CanonicalValueSupport<Uint16> support() {
        return SUPPORT;
    }

    public final Uint16 intern() {
        return this.intValue() < CACHE_SIZE ? this : (Uint16)INTERNER.intern((Object)this);
    }

    public final int toJava() {
        return this.intValue();
    }

    public final Uint8 toUint8() {
        return Uint8.valueOf(this.toJava());
    }

    public final Uint32 toUint32() {
        return Uint32.fromIntBits(this.intValue());
    }

    public final Uint64 toUint64() {
        return Uint64.fromLongBits(this.longValue());
    }

    public final Uint8 toSaturatedUint8() {
        return Uint8.saturatedOf(this.toJava());
    }

    public final int hashCode() {
        return Short.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint16 && this.value == ((Uint16)obj).value;
    }

    public final boolean equals(@Nullable Uint16 obj) {
        return this == obj || obj != null && this.value == obj.value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint16.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(CACHE_SIZE_PROPERTY, 256);
        CACHE_SIZE = p >= 0 ? Math.min(p, 65536) : 256;
        Uint16[] c = new Uint16[CACHE_SIZE];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new Uint16((short)i);
        }
        CACHE = c;
        INTERNER = Interners.newWeakInterner();
        ZERO = Uint16.valueOf(0).intern();
        ONE = Uint16.valueOf(1).intern();
        TWO = Uint16.valueOf(2).intern();
        TEN = Uint16.valueOf(10).intern();
        MAX_VALUE = Uint16.valueOf(65535).intern();
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint16> {
        public Support() {
            super(Uint16.class);
        }

        @Override
        public Variant<Uint16, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst((Object)Uint16.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

