/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8040.parser;

import com.google.common.annotations.Beta;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatement;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataStatements;
import org.opendaylight.yangtools.rfc8040.parser.YangDataEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

@Beta
public final class YangDataStatementSupport
extends AbstractStatementSupport<String, YangDataStatement, YangDataEffectiveStatement> {
    private static final YangDataStatementSupport INSTANCE = new YangDataStatementSupport((StatementDefinition)YangDataStatements.YANG_DATA);
    private final SubstatementValidator validator;

    private YangDataStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).addMandatory((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.USES).build();
    }

    public static YangDataStatementSupport getInstance() {
        return INSTANCE;
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    public String parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return value;
    }

    public YangDataStatement createDeclared(StmtContext<String, YangDataStatement, ?> ctx) {
        return new Declared(ctx);
    }

    public YangDataEffectiveStatement createEffective(StmtContext<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        this.validator.validate(ctx);
        return new YangDataEffectiveStatementImpl(ctx);
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<String, YangDataStatement, YangDataEffectiveStatement> ctx) {
        if (ctx.coerceParentContext().getParentContext() != null) {
            ctx.setIsSupportedToBuildEffective(false);
        }
    }

    public boolean isIgnoringIfFeatures() {
        return true;
    }

    public boolean isIgnoringConfig() {
        return true;
    }

    private static final class Declared
    extends AbstractDeclaredStatement<String>
    implements YangDataStatement {
        Declared(StmtContext<String, YangDataStatement, ?> ctx) {
            super(ctx);
        }

        public String getArgument() {
            return (String)this.argument();
        }
    }
}

